/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Durations;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.BranchType;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.notification.IssuesChangesNotification;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;
import org.sonar.server.issue.notification.IssuesChangesNotificationSerializer;
import org.sonar.server.issue.notification.MyNewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesNotification;

@ComputeEngineSide
public class NotificationFactory {
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final RuleRepository ruleRepository;
    private final Durations durations;
    private final IssuesChangesNotificationSerializer issuesChangesSerializer;
    private Map<String, Component> componentsByUuid;

    public NotificationFactory(TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, RuleRepository ruleRepository, Durations durations, IssuesChangesNotificationSerializer issuesChangesSerializer) {
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.ruleRepository = ruleRepository;
        this.durations = durations;
        this.issuesChangesSerializer = issuesChangesSerializer;
    }

    public MyNewIssuesNotification newMyNewIssuesNotification(Map<String, UserDto> assigneesByUuid) {
        NotificationFactory.verifyAssigneesByUuid(assigneesByUuid);
        return new MyNewIssuesNotification(this.durations, (NewIssuesNotification.DetailsSupplier)new DetailsSupplierImpl(assigneesByUuid));
    }

    public NewIssuesNotification newNewIssuesNotification(Map<String, UserDto> assigneesByUuid) {
        NotificationFactory.verifyAssigneesByUuid(assigneesByUuid);
        return new NewIssuesNotification(this.durations, (NewIssuesNotification.DetailsSupplier)new DetailsSupplierImpl(assigneesByUuid));
    }

    public IssuesChangesNotification newIssuesChangesNotification(Set<DefaultIssue> issues, Map<String, UserDto> assigneesByUuid) {
        IssuesChangesNotificationBuilder.AnalysisChange change = new IssuesChangesNotificationBuilder.AnalysisChange(this.analysisMetadataHolder.getAnalysisDate());
        Set changedIssues = (Set)issues.stream().map(issue -> new IssuesChangesNotificationBuilder.ChangedIssue.Builder(issue.key()).setAssignee(this.getAssignee(issue.assignee(), assigneesByUuid)).setNewResolution(issue.resolution()).setNewStatus(issue.status()).setRule(this.getRuleByRuleKey(issue.ruleKey())).setProject(this.getProject()).build()).collect(MoreCollectors.toSet((int)issues.size()));
        return this.issuesChangesSerializer.serialize(new IssuesChangesNotificationBuilder(changedIssues, (IssuesChangesNotificationBuilder.Change)change));
    }

    @CheckForNull
    public IssuesChangesNotificationBuilder.User getAssignee(@Nullable String assigneeUuid, Map<String, UserDto> assigneesByUuid) {
        if (assigneeUuid == null) {
            return null;
        }
        UserDto dto = assigneesByUuid.get(assigneeUuid);
        Preconditions.checkState((dto != null ? 1 : 0) != 0, (String)"Can not find DTO for assignee uuid %s", (Object[])new Object[]{assigneeUuid});
        return new IssuesChangesNotificationBuilder.User(dto.getUuid(), dto.getLogin(), dto.getName());
    }

    private IssuesChangesNotificationBuilder.Rule getRuleByRuleKey(RuleKey ruleKey) {
        return this.ruleRepository.findByKey(ruleKey).map(t -> new IssuesChangesNotificationBuilder.Rule(ruleKey, t.getName())).orElseThrow(() -> new IllegalStateException("Can not find rule " + ruleKey + " in RuleRepository"));
    }

    private IssuesChangesNotificationBuilder.Project getProject() {
        Component project = this.treeRootHolder.getRoot();
        Branch branch = this.analysisMetadataHolder.getBranch();
        IssuesChangesNotificationBuilder.Project.Builder builder = new IssuesChangesNotificationBuilder.Project.Builder(project.getUuid()).setKey(project.getKey()).setProjectName(project.getName());
        if (!branch.isLegacyFeature() && branch.getType() != BranchType.PULL_REQUEST && !branch.isMain()) {
            builder.setBranchName(branch.getName());
        }
        return builder.build();
    }

    private static void verifyAssigneesByUuid(Map<String, UserDto> assigneesByUuid) {
        Objects.requireNonNull(assigneesByUuid, "assigneesByUuid can't be null");
    }

    private class DetailsSupplierImpl
    implements NewIssuesNotification.DetailsSupplier {
        private final Map<String, UserDto> assigneesByUuid;

        private DetailsSupplierImpl(Map<String, UserDto> assigneesByUuid) {
            this.assigneesByUuid = assigneesByUuid;
        }

        public Optional<NewIssuesNotification.RuleDefinition> getRuleDefinitionByRuleKey(RuleKey ruleKey) {
            Objects.requireNonNull(ruleKey, "ruleKey can't be null");
            return NotificationFactory.this.ruleRepository.findByKey(ruleKey).map(t -> new NewIssuesNotification.RuleDefinition(t.getName(), t.getLanguage()));
        }

        public Optional<String> getComponentNameByUuid(String uuid) {
            Objects.requireNonNull(uuid, "uuid can't be null");
            return Optional.ofNullable(this.lazyLoadComponentsByUuid().get(uuid)).map(t -> t.getType() == Component.Type.FILE || t.getType() == Component.Type.DIRECTORY ? t.getShortName() : t.getName());
        }

        private Map<String, Component> lazyLoadComponentsByUuid() {
            if (NotificationFactory.this.componentsByUuid == null) {
                final ImmutableMap.Builder builder = ImmutableMap.builder();
                new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER){

                    @Override
                    public void visitAny(Component any) {
                        builder.put((Object)any.getUuid(), (Object)any);
                    }
                }).visit(NotificationFactory.this.treeRootHolder.getRoot());
                NotificationFactory.this.componentsByUuid = (Map)builder.build();
            }
            return NotificationFactory.this.componentsByUuid;
        }

        public Optional<String> getUserNameByUuid(String uuid) {
            Objects.requireNonNull(uuid, "uuid can't be null");
            return Optional.ofNullable(this.assigneesByUuid.get(uuid)).map(UserDto::getName);
        }
    }
}

