/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.purge;

import java.util.Collection;
import java.util.List;
import org.sonar.api.server.ServerSide;
import org.sonar.db.purge.PurgeListener;
import org.sonar.server.component.index.ComponentIndexer;
import org.sonar.server.issue.index.IssueIndexer;

@ServerSide
public class IndexPurgeListener
implements PurgeListener {
    private final IssueIndexer issueIndexer;
    private final ComponentIndexer componentIndexer;

    public IndexPurgeListener(IssueIndexer issueIndexer, ComponentIndexer componentIndexer) {
        this.issueIndexer = issueIndexer;
        this.componentIndexer = componentIndexer;
    }

    public void onComponentsDisabling(String projectUuid, Collection<String> disabledComponentUuids) {
        this.componentIndexer.delete(projectUuid, disabledComponentUuids);
    }

    public void onIssuesRemoval(String projectUuid, List<String> issueKeys) {
        this.issueIndexer.deleteByKeys(projectUuid, issueKeys);
    }
}

