/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.source.FileSourceDataWarnings;
import org.sonar.ce.task.projectanalysis.source.SourceLineReadersFactory;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepositoryImpl;
import org.sonar.ce.task.projectanalysis.source.SourceLinesRepository;
import org.sonar.ce.task.projectanalysis.source.linereader.LineReader;
import org.sonar.core.hash.SourceHashComputer;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.protobuf.DbFileSources;

public class FileSourceDataComputer {
    private final SourceLinesRepository sourceLinesRepository;
    private final SourceLineReadersFactory sourceLineReadersFactory;
    private final SourceLinesHashRepository sourceLinesHash;
    private final SourceHashComputer sourceHashComputer;

    public FileSourceDataComputer(SourceLinesRepository sourceLinesRepository, SourceLineReadersFactory sourceLineReadersFactory, SourceLinesHashRepository sourceLinesHash) {
        this.sourceLinesRepository = sourceLinesRepository;
        this.sourceLineReadersFactory = sourceLineReadersFactory;
        this.sourceLinesHash = sourceLinesHash;
        this.sourceHashComputer = new SourceHashComputer();
    }

    public Data compute(Component file, FileSourceDataWarnings fileSourceDataWarnings) {
        try (CloseableIterator<String> linesIterator = this.sourceLinesRepository.readLines(file);){
            SourceLineReadersFactory.LineReaders lineReaders = this.sourceLineReadersFactory.getLineReaders(file);
            try {
                SourceLinesHashRepositoryImpl.LineHashesComputer lineHashesComputer = this.sourceLinesHash.getLineHashesComputerToPersist(file);
                DbFileSources.Data.Builder fileSourceBuilder = DbFileSources.Data.newBuilder();
                int currentLine = 0;
                while (linesIterator.hasNext()) {
                    String lineSource = (String)linesIterator.next();
                    boolean hasNextLine = linesIterator.hasNext();
                    this.sourceHashComputer.addLine(lineSource, hasNextLine);
                    lineHashesComputer.addLine(lineSource);
                    DbFileSources.Line.Builder lineBuilder = fileSourceBuilder.addLinesBuilder().setSource(lineSource).setLine(++currentLine);
                    lineReaders.read(lineBuilder, readError -> fileSourceDataWarnings.addWarning(file, (LineReader.ReadError)readError));
                }
                Changeset latestChangeWithRevision = lineReaders.getLatestChangeWithRevision();
                Data data = new Data(fileSourceBuilder.build(), lineHashesComputer.getResult(), this.sourceHashComputer.getHash(), latestChangeWithRevision);
                if (lineReaders != null) {
                    lineReaders.close();
                }
                return data;
            }
            catch (Throwable throwable) {
                if (lineReaders != null) {
                    try {
                        lineReaders.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static class Data {
        private final DbFileSources.Data fileSourceData;
        private final List<String> lineHashes;
        private final String srcHash;
        private final Changeset latestChangeWithRevision;

        public Data(DbFileSources.Data fileSourceData, List<String> lineHashes, String srcHash, @Nullable Changeset latestChangeWithRevision) {
            this.fileSourceData = fileSourceData;
            this.lineHashes = lineHashes;
            this.srcHash = srcHash;
            this.latestChangeWithRevision = latestChangeWithRevision;
        }

        public String getSrcHash() {
            return this.srcHash;
        }

        public List<String> getLineHashes() {
            return this.lineHashes;
        }

        public DbFileSources.Data getLineData() {
            return this.fileSourceData;
        }

        @CheckForNull
        public Changeset getLatestChangeWithRevision() {
            return this.latestChangeWithRevision;
        }
    }
}

