/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.period.PeriodHolder;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoRepository;

public class NewLinesRepository {
    private final BatchReportReader reportReader;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final ScmInfoRepository scmInfoRepository;
    private final PeriodHolder periodHolder;
    private final Map<Component, Optional<Set<Integer>>> reportChangedLinesCache = new HashMap<Component, Optional<Set<Integer>>>();

    public NewLinesRepository(BatchReportReader reportReader, AnalysisMetadataHolder analysisMetadataHolder, PeriodHolder periodHolder, ScmInfoRepository scmInfoRepository) {
        this.reportReader = reportReader;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.scmInfoRepository = scmInfoRepository;
        this.periodHolder = periodHolder;
    }

    public boolean newLinesAvailable() {
        return this.analysisMetadataHolder.isSLBorPR() || this.periodHolder.hasPeriod();
    }

    public Optional<Set<Integer>> getNewLines(Component file) {
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (Object)("Changed lines are only available on files, but was: " + file.getType().name()));
        Optional<Set<Integer>> reportChangedLines = this.getChangedLinesFromReport(file);
        if (reportChangedLines.isPresent()) {
            return reportChangedLines;
        }
        return this.computeNewLinesFromScm(file);
    }

    private Optional<Set<Integer>> computeNewLinesFromScm(Component component) {
        if (!this.periodHolder.hasPeriod() && !this.analysisMetadataHolder.isSLBorPR()) {
            return Optional.empty();
        }
        Optional<ScmInfo> scmInfoOpt = this.scmInfoRepository.getScmInfo(component);
        if (!scmInfoOpt.isPresent()) {
            return Optional.empty();
        }
        ScmInfo scmInfo = scmInfoOpt.get();
        Map<Integer, Changeset> allChangesets = scmInfo.getAllChangesets();
        HashSet<Integer> lines = new HashSet<Integer>();
        long referenceDate = this.analysisMetadataHolder.isSLBorPR() ? this.analysisMetadataHolder.getAnalysisDate() - 1L : this.periodHolder.getPeriod().getSnapshotDate();
        for (Map.Entry<Integer, Changeset> e : allChangesets.entrySet()) {
            if (!NewLinesRepository.isLineInPeriod(e.getValue().getDate(), referenceDate)) continue;
            lines.add(e.getKey());
        }
        return Optional.of(lines);
    }

    private static boolean isLineInPeriod(long lineDate, long referenceDate) {
        return lineDate > referenceDate;
    }

    private Optional<Set<Integer>> getChangedLinesFromReport(Component file) {
        if (this.analysisMetadataHolder.isSLBorPR()) {
            return this.reportChangedLinesCache.computeIfAbsent(file, this::readFromReport);
        }
        return Optional.empty();
    }

    private Optional<Set<Integer>> readFromReport(Component file) {
        return this.reportReader.readComponentChangedLines(file.getReportAttributes().getRef()).map(c -> new HashSet(c.getLineList()));
    }
}

