/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source.linereader;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.source.linereader.LineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.RangeOffsetConverter;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.scanner.protocol.output.ScannerReport;

public class HighlightingLineReader
implements LineReader {
    private static final Logger LOG = Loggers.get(HighlightingLineReader.class);
    private LineReader.ReadError readError = null;
    private static final Map<ScannerReport.SyntaxHighlightingRule.HighlightingType, String> cssClassByType = ImmutableMap.builder().put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.ANNOTATION, (Object)"a").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.CONSTANT, (Object)"c").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.COMMENT, (Object)"cd").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.CPP_DOC, (Object)"cppd").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.STRUCTURED_COMMENT, (Object)"j").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.KEYWORD, (Object)"k").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.KEYWORD_LIGHT, (Object)"h").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.HIGHLIGHTING_STRING, (Object)"s").put((Object)ScannerReport.SyntaxHighlightingRule.HighlightingType.PREPROCESS_DIRECTIVE, (Object)"p").build();
    private final Component file;
    private final Iterator<ScannerReport.SyntaxHighlightingRule> lineHighlightingIterator;
    private final RangeOffsetConverter rangeOffsetConverter;
    private final List<ScannerReport.SyntaxHighlightingRule> highlightingList;
    private ScannerReport.SyntaxHighlightingRule currentItem;

    public HighlightingLineReader(Component file, Iterator<ScannerReport.SyntaxHighlightingRule> lineHighlightingIterator, RangeOffsetConverter rangeOffsetConverter) {
        this.file = file;
        this.lineHighlightingIterator = lineHighlightingIterator;
        this.rangeOffsetConverter = rangeOffsetConverter;
        this.highlightingList = Lists.newArrayList();
    }

    @Override
    public Optional<LineReader.ReadError> read(DbFileSources.Line.Builder lineBuilder) {
        if (this.readError == null) {
            try {
                this.processHighlightings(lineBuilder);
            }
            catch (RangeOffsetConverter.RangeOffsetConverterException e) {
                this.readError = new LineReader.ReadError(LineReader.Data.HIGHLIGHTING, lineBuilder.getLine());
                LOG.debug(String.format("Inconsistency detected in Highlighting data. Highlighting will be ignored for file '%s'", this.file.getDbKey()), (Object)e);
            }
        }
        return Optional.ofNullable(this.readError);
    }

    private void processHighlightings(DbFileSources.Line.Builder lineBuilder) {
        int line = lineBuilder.getLine();
        StringBuilder highlighting = new StringBuilder();
        this.incrementHighlightingListMatchingLine(line);
        Iterator<ScannerReport.SyntaxHighlightingRule> syntaxHighlightingIterator = this.highlightingList.iterator();
        while (syntaxHighlightingIterator.hasNext()) {
            this.processHighlighting(syntaxHighlightingIterator, highlighting, lineBuilder);
        }
        if (highlighting.length() > 0) {
            lineBuilder.setHighlighting(highlighting.toString());
        }
    }

    private void processHighlighting(Iterator<ScannerReport.SyntaxHighlightingRule> syntaxHighlightingIterator, StringBuilder highlighting, DbFileSources.Line.Builder lineBuilder) {
        ScannerReport.SyntaxHighlightingRule syntaxHighlighting = syntaxHighlightingIterator.next();
        int line = lineBuilder.getLine();
        ScannerReport.TextRange range = syntaxHighlighting.getRange();
        if (range.getStartLine() <= line) {
            String offsets = this.rangeOffsetConverter.offsetToString(syntaxHighlighting.getRange(), line, lineBuilder.getSource().length());
            if (offsets.isEmpty()) {
                if (range.getEndLine() == line) {
                    syntaxHighlightingIterator.remove();
                }
            } else {
                if (highlighting.length() > 0) {
                    highlighting.append(";");
                }
                highlighting.append(offsets).append(",").append(HighlightingLineReader.getCssClass(syntaxHighlighting.getType()));
                if (range.getEndLine() == line) {
                    syntaxHighlightingIterator.remove();
                }
            }
        }
    }

    private static String getCssClass(ScannerReport.SyntaxHighlightingRule.HighlightingType type) {
        String cssClass = cssClassByType.get(type);
        if (cssClass != null) {
            return cssClass;
        }
        throw new IllegalArgumentException(String.format("Unknown type %s ", type.toString()));
    }

    private void incrementHighlightingListMatchingLine(int line) {
        ScannerReport.SyntaxHighlightingRule syntaxHighlighting = this.getNextHighlightingMatchingLine(line);
        while (syntaxHighlighting != null) {
            this.highlightingList.add(syntaxHighlighting);
            this.currentItem = null;
            syntaxHighlighting = this.getNextHighlightingMatchingLine(line);
        }
    }

    @CheckForNull
    private ScannerReport.SyntaxHighlightingRule getNextHighlightingMatchingLine(int line) {
        if (this.currentItem == null && this.lineHighlightingIterator.hasNext()) {
            this.currentItem = this.lineHighlightingIterator.next();
        }
        if (this.currentItem != null && this.currentItem.getRange().getStartLine() == line) {
            return this.currentItem;
        }
        return null;
    }
}

