/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.custom.CustomMeasureDto;

public class CustomMeasuresCopyStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public CustomMeasuresCopyStep(TreeRootHolder treeRootHolder, DbClient dbClient, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    public void execute(ComputationStep.Context context) {
        try (final DbSession session = this.dbClient.openSession(false);){
            CrawlerDepthLimit depthLimit = new CrawlerDepthLimit.Builder(Component.Type.PROJECT).withViewsMaxDepth(Component.Type.PROJECT_VIEW);
            new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(depthLimit, ComponentVisitor.Order.PRE_ORDER){

                @Override
                public void visitAny(Component component) {
                    CustomMeasuresCopyStep.this.copy(component, session);
                }
            }).visit(this.treeRootHolder.getRoot());
        }
    }

    private void copy(Component component, DbSession session) {
        for (CustomMeasureDto dto : this.loadCustomMeasures(component, session)) {
            Metric metric = this.metricRepository.getById(dto.getMetricId());
            Measure measure = CustomMeasuresCopyStep.dtoToMeasure(dto, metric);
            this.measureRepository.add(component, metric, measure);
        }
    }

    private List<CustomMeasureDto> loadCustomMeasures(Component component, DbSession session) {
        return this.dbClient.customMeasureDao().selectByComponentUuid(session, component.getUuid());
    }

    @VisibleForTesting
    static Measure dtoToMeasure(CustomMeasureDto dto, Metric metric) {
        switch (metric.getType()) {
            case INT: 
            case RATING: {
                return Measure.newMeasureBuilder().create((int)dto.getValue());
            }
            case MILLISEC: 
            case WORK_DUR: {
                return Measure.newMeasureBuilder().create((long)dto.getValue());
            }
            case FLOAT: 
            case PERCENT: {
                return Measure.newMeasureBuilder().create(dto.getValue(), metric.getDecimalScale());
            }
            case BOOL: {
                return Measure.newMeasureBuilder().create(NumberUtils.compare((double)dto.getValue(), (double)1.0) == 0);
            }
            case LEVEL: {
                return Measure.newMeasureBuilder().create(Measure.Level.valueOf(dto.getTextValue()));
            }
            case STRING: 
            case DISTRIB: 
            case DATA: {
                String textValue = dto.getTextValue();
                if (textValue == null) {
                    return Measure.newMeasureBuilder().createNoValue();
                }
                return Measure.newMeasureBuilder().create(textValue);
            }
        }
        throw new IllegalArgumentException(String.format("Custom measures do not support the metric type [%s]", new Object[]{metric.getType()}));
    }

    public String getDescription() {
        return "Copy custom measures";
    }
}

