/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.server.es.ProjectIndexer;

public class IndexAnalysisStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(IndexAnalysisStep.class);
    private final TreeRootHolder treeRootHolder;
    private final ProjectIndexer[] indexers;

    public IndexAnalysisStep(TreeRootHolder treeRootHolder, ProjectIndexer ... indexers) {
        this.treeRootHolder = treeRootHolder;
        this.indexers = indexers;
    }

    public void execute(ComputationStep.Context context) {
        String branchUuid = this.treeRootHolder.getRoot().getUuid();
        for (ProjectIndexer indexer : this.indexers) {
            LOGGER.debug("Call {}", (Object)indexer);
            indexer.indexOnAnalysis(branchUuid);
        }
    }

    public String getDescription() {
        return "Index analysis";
    }
}

