/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.Analysis;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicationStatusHolder;
import org.sonar.ce.task.projectanalysis.duplication.IntegrateCrossProjectDuplications;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.duplication.DuplicationUnitDto;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.scanner.protocol.output.ScannerReport;

public class LoadCrossProjectDuplicationsRepositoryStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(LoadCrossProjectDuplicationsRepositoryStep.class);
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final IntegrateCrossProjectDuplications integrateCrossProjectDuplications;
    private final CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder;
    private final DbClient dbClient;

    public LoadCrossProjectDuplicationsRepositoryStep(TreeRootHolder treeRootHolder, BatchReportReader reportReader, AnalysisMetadataHolder analysisMetadataHolder, CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder, IntegrateCrossProjectDuplications integrateCrossProjectDuplications, DbClient dbClient) {
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.integrateCrossProjectDuplications = integrateCrossProjectDuplications;
        this.crossProjectDuplicationStatusHolder = crossProjectDuplicationStatusHolder;
        this.dbClient = dbClient;
    }

    public void execute(ComputationStep.Context context) {
        if (this.crossProjectDuplicationStatusHolder.isEnabled()) {
            new DepthTraversalTypeAwareCrawler(new CrossProjectDuplicationVisitor()).visit(this.treeRootHolder.getRoot());
        }
    }

    public String getDescription() {
        return "Compute cross project duplications";
    }

    private static class CpdTextBlockToBlock
    implements Function<ScannerReport.CpdTextBlock, Block> {
        private final String fileKey;
        private int indexInFile = 0;

        CpdTextBlockToBlock(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public Block apply(@Nonnull ScannerReport.CpdTextBlock duplicationBlock) {
            Block block = Block.builder().setResourceId(this.fileKey).setBlockHash(new ByteArray(duplicationBlock.getHash())).setIndexInFile(this.indexInFile).setLines(duplicationBlock.getStartLine(), duplicationBlock.getEndLine()).setUnit(duplicationBlock.getStartTokenIndex(), duplicationBlock.getEndTokenIndex()).build();
            ++this.indexInFile;
            return block;
        }
    }

    private static enum DtoToBlock implements Function<DuplicationUnitDto, Block>
    {
        INSTANCE;


        @Override
        public Block apply(@Nonnull DuplicationUnitDto dto) {
            return Block.builder().setResourceId(dto.getComponentKey()).setBlockHash(new ByteArray(dto.getHash())).setIndexInFile(dto.getIndexInFile()).setLines(dto.getStartLine(), dto.getEndLine()).build();
        }
    }

    private static enum CpdTextBlockToHash implements Function<ScannerReport.CpdTextBlock, String>
    {
        INSTANCE;


        @Override
        public String apply(@Nonnull ScannerReport.CpdTextBlock duplicationBlock) {
            return duplicationBlock.getHash();
        }
    }

    private class CrossProjectDuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private CrossProjectDuplicationVisitor() {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
        }

        @Override
        public void visitFile(Component file) {
            ArrayList<ScannerReport.CpdTextBlock> cpdTextBlocks = new ArrayList<ScannerReport.CpdTextBlock>();
            try (CloseableIterator<ScannerReport.CpdTextBlock> blocksIt = LoadCrossProjectDuplicationsRepositoryStep.this.reportReader.readCpdTextBlocks(file.getReportAttributes().getRef());){
                while (blocksIt.hasNext()) {
                    cpdTextBlocks.add((ScannerReport.CpdTextBlock)blocksIt.next());
                }
            }
            LOGGER.trace("Found {} cpd blocks on file {}", (Object)cpdTextBlocks.size(), (Object)file.getDbKey());
            if (cpdTextBlocks.isEmpty()) {
                return;
            }
            Collection hashes = cpdTextBlocks.stream().map(CpdTextBlockToHash.INSTANCE).collect(Collectors.toList());
            List<DuplicationUnitDto> dtos = this.selectDuplicates(file, hashes);
            if (dtos.isEmpty()) {
                return;
            }
            Collection duplicatedBlocks = dtos.stream().map(DtoToBlock.INSTANCE).collect(Collectors.toList());
            Collection originBlocks = cpdTextBlocks.stream().map(new CpdTextBlockToBlock(file.getDbKey())).collect(Collectors.toList());
            LOGGER.trace("Found {} duplicated cpd blocks on file {}", (Object)duplicatedBlocks.size(), (Object)file.getDbKey());
            LoadCrossProjectDuplicationsRepositoryStep.this.integrateCrossProjectDuplications.computeCpd(file, originBlocks, duplicatedBlocks);
        }

        private List<DuplicationUnitDto> selectDuplicates(Component file, Collection<String> hashes) {
            try (DbSession dbSession = LoadCrossProjectDuplicationsRepositoryStep.this.dbClient.openSession(false);){
                Analysis projectAnalysis = LoadCrossProjectDuplicationsRepositoryStep.this.analysisMetadataHolder.getBaseAnalysis();
                String analysisUuid = projectAnalysis == null ? null : projectAnalysis.getUuid();
                List list = LoadCrossProjectDuplicationsRepositoryStep.this.dbClient.duplicationDao().selectCandidates(dbSession, analysisUuid, file.getFileAttributes().getLanguageKey(), hashes);
                return list;
            }
        }
    }
}

