/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.counter.IntValue;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;
import org.sonar.ce.task.step.ComputationStep;

public class NewSizeMeasuresStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final NewDuplicationFormula duplicationFormula;

    public NewSizeMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, NewLinesRepository newLinesRepository, DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.duplicationFormula = new NewDuplicationFormula(newLinesRepository, duplicationRepository);
    }

    public String getDescription() {
        return "Compute size measures on new code";
    }

    public void execute(ComputationStep.Context context) {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)ImmutableList.of((Object)this.duplicationFormula))).visit(this.treeRootHolder.getRoot());
    }

    private static final class NewDuplicationFormula
    implements Formula<NewSizeCounter> {
        private final DuplicationRepository duplicationRepository;
        private final NewLinesRepository newLinesRepository;

        private NewDuplicationFormula(NewLinesRepository newLinesRepository, DuplicationRepository duplicationRepository) {
            this.duplicationRepository = duplicationRepository;
            this.newLinesRepository = newLinesRepository;
        }

        @Override
        public NewSizeCounter createNewCounter() {
            return new NewSizeCounter(this.duplicationRepository, this.newLinesRepository);
        }

        @Override
        public Optional<Measure> createMeasure(NewSizeCounter counter, CreateMeasureContext context) {
            String metricKey;
            switch (metricKey = context.getMetric().getKey()) {
                case "new_lines": {
                    return NewDuplicationFormula.createMeasure(counter.newLines);
                }
                case "new_duplicated_lines": {
                    return NewDuplicationFormula.createMeasure(counter.newDuplicatedLines);
                }
                case "new_duplicated_lines_density": {
                    return NewDuplicationFormula.createNewDuplicatedLinesDensityMeasure(counter);
                }
                case "new_duplicated_blocks": {
                    return NewDuplicationFormula.createMeasure(counter.newDuplicatedBlocks);
                }
            }
            throw new IllegalArgumentException("Unsupported metric " + context.getMetric());
        }

        private static Optional<Measure> createMeasure(IntValue intValue) {
            return intValue.isSet() ? Optional.of(Measure.newMeasureBuilder().setVariation(intValue.getValue()).createNoValue()) : Optional.empty();
        }

        private static Optional<Measure> createNewDuplicatedLinesDensityMeasure(NewSizeCounter counter) {
            IntValue newLines = counter.newLines;
            IntValue newDuplicatedLines = counter.newDuplicatedLines;
            if (newLines.isSet() && newDuplicatedLines.isSet()) {
                int newLinesVariations = newLines.getValue();
                int newDuplicatedLinesVariations = newDuplicatedLines.getValue();
                if ((double)newLinesVariations > 0.0) {
                    double density = Math.min(100.0, 100.0 * (double)newDuplicatedLinesVariations / (double)newLinesVariations);
                    return Optional.of(Measure.newMeasureBuilder().setVariation(density).createNoValue());
                }
            }
            return Optional.empty();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"new_lines", "new_duplicated_lines", "new_duplicated_lines_density", "new_duplicated_blocks"};
        }
    }

    private static class DuplicationCounters {
        private final Set<Integer> changedLines;
        private final Set<Integer> lineCounts;
        private int blockCounts;

        private DuplicationCounters(Set<Integer> changedLines) {
            this.changedLines = changedLines;
            this.lineCounts = new HashSet<Integer>(changedLines.size());
        }

        void addBlock(TextBlock textBlock) {
            Boolean[] newBlock = new Boolean[]{false};
            IntStream.rangeClosed(textBlock.getStart(), textBlock.getEnd()).filter(this.changedLines::contains).forEach(line -> {
                this.lineCounts.add(line);
                newBlock[0] = true;
            });
            if (newBlock[0].booleanValue()) {
                ++this.blockCounts;
            }
        }

        int getNewLinesDuplicated() {
            return this.lineCounts.size();
        }

        int getNewBlocksDuplicated() {
            return this.blockCounts;
        }
    }

    private static class NewSizeCounter
    implements Counter<NewSizeCounter> {
        private final DuplicationRepository duplicationRepository;
        private final NewLinesRepository newLinesRepository;
        private final IntValue newLines = new IntValue();
        private final IntValue newDuplicatedLines = new IntValue();
        private final IntValue newDuplicatedBlocks = new IntValue();

        private NewSizeCounter(DuplicationRepository duplicationRepository, NewLinesRepository newLinesRepository) {
            this.duplicationRepository = duplicationRepository;
            this.newLinesRepository = newLinesRepository;
        }

        @Override
        public void aggregate(NewSizeCounter counter) {
            this.newDuplicatedLines.increment(counter.newDuplicatedLines);
            this.newDuplicatedBlocks.increment(counter.newDuplicatedBlocks);
            this.newLines.increment(counter.newLines);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component leaf = context.getLeaf();
            if (leaf.getType() != Component.Type.FILE) {
                return;
            }
            Optional<Set<Integer>> changedLines = this.newLinesRepository.getNewLines(leaf);
            if (!changedLines.isPresent()) {
                return;
            }
            this.newLines.increment(0);
            if (leaf.getType() != Component.Type.FILE) {
                this.newDuplicatedLines.increment(0);
                this.newDuplicatedBlocks.increment(0);
            } else {
                this.initNewLines(changedLines.get());
                this.initNewDuplicated(leaf, changedLines.get());
            }
        }

        private void initNewLines(Set<Integer> changedLines) {
            this.newLines.increment(changedLines.size());
        }

        private void initNewDuplicated(Component component, Set<Integer> changedLines) {
            DuplicationCounters duplicationCounters = new DuplicationCounters(changedLines);
            Iterable<Duplication> duplications = this.duplicationRepository.getDuplications(component);
            for (Duplication duplication : duplications) {
                duplicationCounters.addBlock(duplication.getOriginal());
                duplication.getDuplicates().stream().filter(InnerDuplicate.class::isInstance).map(duplicate -> (InnerDuplicate)duplicate).forEach(duplicate -> duplicationCounters.addBlock(duplicate.getTextBlock()));
            }
            this.newDuplicatedLines.increment(duplicationCounters.getNewLinesDuplicated());
            this.newDuplicatedBlocks.increment(duplicationCounters.getNewBlocksDuplicated());
        }
    }
}

