/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.InExtendedProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.LiveMeasureDto;

public class PersistDuplicationDataStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final DuplicationRepository duplicationRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final Metric duplicationDataMetric;

    public PersistDuplicationDataStep(DbClient dbClient, TreeRootHolder treeRootHolder, MetricRepository metricRepository, DuplicationRepository duplicationRepository, MeasureToMeasureDto measureToMeasureDto) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.duplicationRepository = duplicationRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.duplicationDataMetric = metricRepository.getByKey("duplications_data");
    }

    public void execute(ComputationStep.Context context) {
        boolean supportUpsert = this.dbClient.getDatabase().getDialect().supportsUpsert();
        try (DbSession dbSession = this.dbClient.openSession(false);
             DuplicationVisitor visitor = new DuplicationVisitor(dbSession, supportUpsert);){
            new DepthTraversalTypeAwareCrawler(visitor).visit(this.treeRootHolder.getRoot());
            context.getStatistics().add("insertsOrUpdates", (Object)visitor.insertsOrUpdates);
        }
    }

    public String getDescription() {
        return "Persist duplication data";
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter
    implements AutoCloseable {
        private final DbSession dbSession;
        private final boolean supportUpsert;
        private final List<LiveMeasureDto> nonPersistedBuffer;
        private int insertsOrUpdates;

        private DuplicationVisitor(DbSession dbSession, boolean supportUpsert) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.nonPersistedBuffer = new ArrayList<LiveMeasureDto>();
            this.insertsOrUpdates = 0;
            this.dbSession = dbSession;
            this.supportUpsert = supportUpsert;
        }

        @Override
        public void visitFile(Component file) {
            Iterable<Duplication> duplications = PersistDuplicationDataStep.this.duplicationRepository.getDuplications(file);
            if (!Iterables.isEmpty(duplications)) {
                this.computeDuplications(file, duplications);
            }
        }

        private void computeDuplications(Component component, Iterable<Duplication> duplications) {
            Measure measure = this.generateMeasure(component.getDbKey(), duplications);
            LiveMeasureDto dto = PersistDuplicationDataStep.this.measureToMeasureDto.toLiveMeasureDto(measure, PersistDuplicationDataStep.this.duplicationDataMetric, component);
            this.nonPersistedBuffer.add(dto);
            this.persist(false);
        }

        private void persist(boolean force) {
            boolean shouldPersist;
            boolean bl = shouldPersist = !this.nonPersistedBuffer.isEmpty() && (force || this.nonPersistedBuffer.size() > 100);
            if (!shouldPersist) {
                return;
            }
            if (this.supportUpsert) {
                PersistDuplicationDataStep.this.dbClient.liveMeasureDao().upsert(this.dbSession, this.nonPersistedBuffer);
            } else {
                this.nonPersistedBuffer.forEach(d -> PersistDuplicationDataStep.this.dbClient.liveMeasureDao().insertOrUpdate(this.dbSession, d));
            }
            this.insertsOrUpdates += this.nonPersistedBuffer.size();
            this.nonPersistedBuffer.clear();
            this.dbSession.commit();
        }

        @Override
        public void close() {
            this.persist(true);
        }

        private Measure generateMeasure(String componentDbKey, Iterable<Duplication> duplications) {
            StringBuilder xml = new StringBuilder();
            xml.append("<duplications>");
            for (Duplication duplication : duplications) {
                xml.append("<g>");
                this.appendDuplication(xml, componentDbKey, duplication.getOriginal(), false);
                for (Duplicate duplicate : duplication.getDuplicates()) {
                    this.processDuplicationBlock(xml, duplicate, componentDbKey);
                }
                xml.append("</g>");
            }
            xml.append("</duplications>");
            return Measure.newMeasureBuilder().create(xml.toString());
        }

        private void processDuplicationBlock(StringBuilder xml, Duplicate duplicate, String componentDbKey) {
            if (duplicate instanceof InnerDuplicate) {
                this.appendDuplication(xml, componentDbKey, duplicate);
            } else if (duplicate instanceof InExtendedProjectDuplicate) {
                this.appendDuplication(xml, ((InExtendedProjectDuplicate)duplicate).getFile().getDbKey(), duplicate.getTextBlock(), true);
            } else if (duplicate instanceof InProjectDuplicate) {
                this.appendDuplication(xml, ((InProjectDuplicate)duplicate).getFile().getDbKey(), duplicate);
            } else if (duplicate instanceof CrossProjectDuplicate) {
                String crossProjectComponentKey = ((CrossProjectDuplicate)duplicate).getFileKey();
                this.appendDuplication(xml, crossProjectComponentKey, duplicate);
            } else {
                throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
            }
        }

        private void appendDuplication(StringBuilder xml, String componentDbKey, Duplicate duplicate) {
            this.appendDuplication(xml, componentDbKey, duplicate.getTextBlock(), false);
        }

        private void appendDuplication(StringBuilder xml, String componentDbKey, TextBlock textBlock, boolean disableLink) {
            int length = textBlock.getEnd() - textBlock.getStart() + 1;
            xml.append("<b s=\"").append(textBlock.getStart()).append("\" l=\"").append(length).append("\" t=\"").append(disableLink).append("\" r=\"").append(StringEscapeUtils.escapeXml((String)componentDbKey)).append("\"/>");
        }
    }
}

