/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualitygate.EvaluationResult;
import org.sonar.ce.task.projectanalysis.step.QualityGateMeasuresStep;

public class SmallChangesetQualityGateSpecialCase {
    private static final Collection<String> METRICS_TO_IGNORE_ON_SMALL_CHANGESETS = Arrays.asList("new_coverage", "new_line_coverage", "new_branch_coverage", "new_duplicated_lines_density", "new_duplicated_lines", "new_duplicated_blocks");
    private static final int MAXIMUM_NEW_LINES_FOR_SMALL_CHANGESETS = 19;
    private final MeasureRepository measureRepository;
    private final MetricRepository metricRepository;

    public SmallChangesetQualityGateSpecialCase(MeasureRepository measureRepository, MetricRepository metricRepository) {
        this.measureRepository = measureRepository;
        this.metricRepository = metricRepository;
    }

    public boolean appliesTo(Component project, @Nullable QualityGateMeasuresStep.MetricEvaluationResult metricEvaluationResult) {
        return metricEvaluationResult != null && metricEvaluationResult.evaluationResult.getLevel() != Measure.Level.OK && METRICS_TO_IGNORE_ON_SMALL_CHANGESETS.contains(metricEvaluationResult.condition.getMetric().getKey()) && this.isSmallChangeset(project);
    }

    QualityGateMeasuresStep.MetricEvaluationResult apply(QualityGateMeasuresStep.MetricEvaluationResult metricEvaluationResult) {
        return new QualityGateMeasuresStep.MetricEvaluationResult(new EvaluationResult(Measure.Level.OK, metricEvaluationResult.evaluationResult.getValue()), metricEvaluationResult.condition);
    }

    private boolean isSmallChangeset(Component project) {
        return this.measureRepository.getRawMeasure(project, this.metricRepository.getByKey("new_lines")).map(newLines -> newLines.hasVariation() && newLines.getVariation() <= 19.0).orElse(false);
    }
}

