/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;

public class UpdateQualityProfilesLastUsedDateStep
implements ComputationStep {
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public UpdateQualityProfilesLastUsedDateStep(DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    public void execute(ComputationStep.Context context) {
        Component root = this.treeRootHolder.getRoot();
        Metric metric = this.metricRepository.getByKey("quality_profiles");
        Set<QualityProfile> qualityProfiles = UpdateQualityProfilesLastUsedDateStep.parseQualityProfiles(this.measureRepository.getRawMeasure(root, metric));
        try (DbSession dbSession = this.dbClient.openSession(true);){
            for (QualityProfile qualityProfile : qualityProfiles) {
                this.updateDate(dbSession, qualityProfile.getQpKey(), this.analysisMetadataHolder.getAnalysisDate());
            }
            dbSession.commit();
        }
    }

    private void updateDate(DbSession dbSession, String qProfileUuid, long lastUsedDate) {
        QProfileDto dto = this.dbClient.qualityProfileDao().selectOrFailByUuid(dbSession, qProfileUuid);
        this.dbClient.qualityProfileDao().updateLastUsedDate(dbSession, dto, lastUsedDate);
        String parentUuid = dto.getParentKee();
        if (parentUuid != null) {
            this.updateDate(dbSession, parentUuid, lastUsedDate);
        }
    }

    public String getDescription() {
        return "Update last usage date of quality profiles";
    }

    private static Set<QualityProfile> parseQualityProfiles(Optional<Measure> measure) {
        if (!measure.isPresent()) {
            return Collections.emptySet();
        }
        String data = measure.get().getStringValue();
        return data == null ? Collections.emptySet() : QPMeasureData.fromJson((String)data).getProfiles();
    }
}

