/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import org.sonar.api.utils.MessageException;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Organization;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;

public class VerifyBillingStep
implements ComputationStep {
    private final AnalysisMetadataHolder analysisMetadata;
    private final BillingValidations billingValidations;

    public VerifyBillingStep(AnalysisMetadataHolder analysisMetadata, BillingValidationsProxy billingValidations) {
        this.analysisMetadata = analysisMetadata;
        this.billingValidations = billingValidations;
    }

    public void execute(ComputationStep.Context context) {
        try {
            Organization organization = this.analysisMetadata.getOrganization();
            BillingValidations.Organization billingOrganization = new BillingValidations.Organization(organization.getKey(), organization.getUuid(), organization.getName());
            this.billingValidations.checkBeforeProjectAnalysis(billingOrganization);
        }
        catch (BillingValidations.BillingValidationsException e) {
            throw MessageException.of((String)e.getMessage());
        }
    }

    public String getDescription() {
        return "Verify billing";
    }
}

