/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.Visitor;

public class EngineContext {
    private List<Issue> issues = new ArrayList<Issue>();
    private Map<UastNode.Kind, List<Visitor>> registeredVisitors = new EnumMap<UastNode.Kind, List<Visitor>>(UastNode.Kind.class);
    private Set<Visitor> visitors = null;

    public EngineContext(Collection<Check> visitors) {
        this.visitors = new HashSet<Check>(visitors);
    }

    public void register(UastNode.Kind kind, Visitor visitor) {
        this.registeredVisitors.computeIfAbsent(kind, k -> new ArrayList()).add(visitor);
    }

    public List<Visitor> registeredVisitors(UastNode.Kind kind) {
        return this.registeredVisitors.getOrDefault(kind, Collections.emptyList());
    }

    public void reportIssue(Issue issue) {
        this.issues.add(issue);
    }

    void enterFile(InputFile inputFile) throws IOException {
        this.issues.clear();
        for (Visitor c : this.getVisitors()) {
            c.enterFile(inputFile);
        }
    }

    public List<Issue> getIssues() {
        return new ArrayList<Issue>(this.issues);
    }

    private Set<Visitor> getVisitors() {
        return this.visitors;
    }
}

