/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.EngineContext;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1451")
public class FileHeaderCheck
extends Check {
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Pattern headerPattern;

    public FileHeaderCheck() {
        super(new UastNode.Kind[0]);
    }

    @Override
    public void initialize(EngineContext context) {
        super.initialize(context);
        this.headerPattern = Pattern.compile(this.getHeaderFormat(), 32);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        Matcher matcher;
        String contents = inputFile.contents();
        if (!this.isRegularExpression) {
            contents = FileHeaderCheck.normalizeEOL(contents);
        }
        if (!(matcher = this.headerPattern.matcher(contents)).lookingAt()) {
            this.reportIssueOnFile("Add or update the header of this file.");
        }
    }

    private String getHeaderFormat() {
        if (this.isRegularExpression) {
            return FileHeaderCheck.normalizeRegexEOL(this.headerFormat);
        }
        return Pattern.quote(FileHeaderCheck.normalizeEOL(this.headerFormat));
    }

    private static String normalizeRegexEOL(String headerFormat) {
        return headerFormat.replaceAll("\r?\n", "\\\\R");
    }

    private static String normalizeEOL(String contents) {
        return contents.replace("\r", DEFAULT_HEADER_FORMAT);
    }

    @Override
    public void visitNode(UastNode node) {
    }
}

