/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.CaseLike;
import org.sonar.uast.helpers.IfLike;
import org.sonar.uast.helpers.SwitchLike;

@Rule(key="S1862")
public class NoIdenticalConditionsCheck
extends Check {
    public NoIdenticalConditionsCheck() {
        super(UastNode.Kind.IF, UastNode.Kind.SWITCH);
    }

    @Override
    public void visitNode(UastNode node) {
        this.handleIf(node);
        this.handleSwitch(node);
    }

    private void handleSwitch(UastNode node) {
        SwitchLike switchLike = SwitchLike.from(node);
        if (switchLike == null) {
            return;
        }
        List<UastNode> caseNodes = switchLike.caseNodes();
        ArrayList<UastNode> allConditions = new ArrayList<UastNode>();
        for (UastNode caseNode : caseNodes) {
            CaseLike caseLike = CaseLike.from(caseNode);
            List<UastNode> conditions = caseLike.conditions();
            for (UastNode condition : conditions) {
                for (UastNode prevCondition : allConditions) {
                    this.checkConditions(condition, prevCondition);
                }
                allConditions.add(condition);
            }
        }
    }

    private void handleIf(UastNode node) {
        IfLike ifLike = IfLike.from(node);
        if (ifLike == null) {
            return;
        }
        UastNode condition = ifLike.condition();
        for (IfLike elseIf = ifLike.elseIf(); elseIf != null; elseIf = elseIf.elseIf()) {
            this.checkConditions(elseIf.condition(), condition);
        }
    }

    private void checkConditions(UastNode condition, UastNode prevCondition) {
        UastNode.Token prevConditionToken = prevCondition.firstToken();
        if (prevConditionToken != null && SyntacticEquivalence.areEquivalent(condition, prevCondition)) {
            int prevConditionLine = prevConditionToken.line;
            this.reportIssue(condition, "This condition is same as one already tested on line " + prevConditionLine + ".", new Issue.Message(prevCondition, "Original"));
        }
    }
}

