/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.BinaryExpressionLike;

@Rule(key="S1125")
public class RedundantBooleanLiteralCheck
extends Check {
    public RedundantBooleanLiteralCheck() {
        super(UastNode.Kind.BINARY_EXPRESSION);
    }

    @Override
    public void visitNode(UastNode node) {
        BinaryExpressionLike binExpr = BinaryExpressionLike.from(node);
        if (binExpr == null) {
            return;
        }
        Optional<UastNode> booleanLiteralOperand = RedundantBooleanLiteralCheck.findBooleanLiteralOperand(binExpr);
        if (binExpr.node().is(UastNode.Kind.EQUAL, UastNode.Kind.NOT_EQUAL, UastNode.Kind.LOGICAL_AND, UastNode.Kind.LOGICAL_OR) && booleanLiteralOperand.isPresent()) {
            this.reportIssue(booleanLiteralOperand.get(), "Remove this redundant boolean literal");
        }
    }

    private static Optional<UastNode> findBooleanLiteralOperand(BinaryExpressionLike binExpr) {
        if (binExpr.rightOperand().is(UastNode.Kind.BOOLEAN_LITERAL)) {
            return Optional.of(binExpr.rightOperand());
        }
        if (binExpr.leftOperand().is(UastNode.Kind.BOOLEAN_LITERAL)) {
            return Optional.of(binExpr.leftOperand());
        }
        return Optional.empty();
    }
}

