/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S103")
public class TooLongLineCheck
extends Check {
    private static final int DEFAULT_MAXIMUM = 120;
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="120")
    public int maximum = 120;

    public TooLongLineCheck() {
        super(new UastNode.Kind[0]);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        String[] lines = inputFile.contents().split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() <= this.maximum) continue;
            String message = String.format(MESSAGE, line.length(), this.maximum);
            this.reportIssueOnLine(i + 1, message);
        }
    }

    @Override
    public void visitNode(UastNode node) {
    }
}

