/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S104")
public class TooManyLinesInFileCheck
extends Check {
    private static final int DEFAULT_MAXIMUM = 750;
    @RuleProperty(key="Max", description="Maximum authorized lines in a file.", defaultValue="750")
    public int maximum = 750;

    public TooManyLinesInFileCheck() {
        super(UastNode.Kind.EOF);
    }

    @Override
    public void visitNode(UastNode node) {
        if (node.token.line > this.maximum) {
            this.reportIssueOnFile("This file has " + node.token.line + " lines, which is greater than " + this.maximum + " authorized. Split it into smaller files.");
        }
    }
}

