/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.uast.UastNode;

public class ArrayAccessLike {
    public static final UastNode.Kind KIND = UastNode.Kind.ARRAY_ACCESS_EXPRESSION;
    private final UastNode node;
    private final UastNode objectExpression;
    private final UastNode keyExpression;

    private ArrayAccessLike(UastNode node, UastNode objectExpression, UastNode keyExpression) {
        this.node = node;
        this.objectExpression = objectExpression;
        this.keyExpression = keyExpression;
    }

    @CheckForNull
    public static ArrayAccessLike from(UastNode node) {
        if (node.is(KIND)) {
            Optional<UastNode> objectExpression = node.getChild(UastNode.Kind.ARRAY_OBJECT_EXPRESSION);
            Optional<UastNode> keyExpression = node.getChild(UastNode.Kind.ARRAY_KEY_EXPRESSION);
            if (objectExpression.isPresent() && keyExpression.isPresent()) {
                return new ArrayAccessLike(node, objectExpression.get(), keyExpression.get());
            }
        }
        return null;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode objectExpression() {
        return this.objectExpression;
    }

    public UastNode keyExpression() {
        return this.keyExpression;
    }
}

