/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.uast.UastNode;

public class AssignmentLike {
    public static final UastNode.Kind KIND = UastNode.Kind.ASSIGNMENT;
    private final UastNode node;
    private final UastNode target;
    private final UastNode operator;
    private final UastNode value;
    private final boolean multiple;
    private List<AssignmentLike> assignmentsTuples = null;

    private AssignmentLike(UastNode node, UastNode target, UastNode operator, UastNode value, boolean multiple) {
        this.node = node;
        this.target = target;
        this.operator = operator;
        this.value = value;
        this.multiple = multiple;
    }

    @CheckForNull
    public static AssignmentLike from(UastNode node) {
        if (node.is(KIND)) {
            Optional<UastNode> operator = node.getChild(UastNode.Kind.ASSIGNMENT_OPERATOR);
            if (!operator.isPresent()) {
                return null;
            }
            Optional<UastNode> target = node.getChild(UastNode.Kind.ASSIGNMENT_TARGET);
            Optional<UastNode> value = node.getChild(UastNode.Kind.ASSIGNMENT_VALUE);
            if (target.isPresent() && value.isPresent()) {
                return new AssignmentLike(node, target.get(), operator.get(), value.get(), false);
            }
            target = node.getChild(UastNode.Kind.ASSIGNMENT_TARGET_LIST);
            value = node.getChild(UastNode.Kind.ASSIGNMENT_VALUE_LIST);
            if (target.isPresent() && value.isPresent()) {
                return new AssignmentLike(node, target.get(), operator.get(), value.get(), true);
            }
        }
        return null;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public List<AssignmentLike> assignmentsTuples() {
        if (this.assignmentsTuples != null) {
            return this.assignmentsTuples;
        }
        if (!this.multiple) {
            this.assignmentsTuples = Collections.singletonList(this);
        } else {
            List<UastNode> targets = this.target.getChildren(UastNode.Kind.ASSIGNMENT_TARGET);
            List<UastNode> values = this.value.getChildren(UastNode.Kind.ASSIGNMENT_VALUE);
            int nbTargets = targets.size();
            if (nbTargets != values.size()) {
                return Collections.emptyList();
            }
            ArrayList<AssignmentLike> result = new ArrayList<AssignmentLike>(nbTargets);
            for (int i = 0; i < nbTargets; ++i) {
                result.add(new AssignmentLike(this.node, targets.get(i), this.operator, values.get(i), false));
            }
            this.assignmentsTuples = Collections.unmodifiableList(result);
        }
        return this.assignmentsTuples;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode target() {
        return this.target;
    }

    public UastNode operator() {
        return this.operator;
    }

    public UastNode value() {
        return this.value;
    }
}

