/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

public class ForLike {
    public static final UastNode.Kind KIND = UastNode.Kind.FOR;
    private final UastNode node;
    private final UastNode forKeyword;
    @Nullable
    private final UastNode init;
    private final UastNode condition;
    @Nullable
    private final UastNode update;
    private final UastNode body;

    private ForLike(UastNode node, UastNode forKeyword, @Nullable UastNode init, UastNode condition, @Nullable UastNode update, UastNode body) {
        this.node = node;
        this.forKeyword = forKeyword;
        this.init = init;
        this.condition = condition;
        this.update = update;
        this.body = body;
    }

    @CheckForNull
    public static ForLike from(UastNode node) {
        if (node.is(KIND)) {
            Optional<UastNode> forKeyword = node.getChild(UastNode.Kind.FOR_KEYWORD);
            Optional<UastNode> condition = node.getChild(UastNode.Kind.CONDITION);
            Optional<UastNode> body = node.getChild(UastNode.Kind.BODY);
            if (forKeyword.isPresent() && condition.isPresent() && body.isPresent()) {
                UastNode init = node.getChild(UastNode.Kind.FOR_INIT).orElse(null);
                UastNode update = node.getChild(UastNode.Kind.FOR_UPDATE).orElse(null);
                return new ForLike(node, forKeyword.get(), init, condition.get(), update, body.get());
            }
        }
        return null;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode forKeyword() {
        return this.forKeyword;
    }

    @CheckForNull
    public UastNode init() {
        return this.init;
    }

    public UastNode condition() {
        return this.condition;
    }

    @CheckForNull
    public UastNode update() {
        return this.update;
    }

    public UastNode body() {
        return this.body;
    }
}

