/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

public class IfLike {
    private final UastNode node;
    private final UastNode ifKeyword;
    private final UastNode condition;
    private final UastNode thenNode;
    @Nullable
    private final ElseLike elseLike;

    private IfLike(UastNode node, UastNode ifKeyword, UastNode condition, UastNode thenNode, @Nullable ElseLike elseLike) {
        this.node = node;
        this.ifKeyword = ifKeyword;
        this.condition = condition;
        this.thenNode = thenNode;
        this.elseLike = elseLike;
    }

    @CheckForNull
    public static IfLike from(@Nullable UastNode node) {
        if (node == null) {
            return null;
        }
        if (node.is(UastNode.Kind.IF)) {
            Optional<UastNode> ifKeyword = node.getChild(UastNode.Kind.IF_KEYWORD);
            Optional<UastNode> condition = node.getChild(UastNode.Kind.CONDITION);
            Optional<UastNode> thenNode = node.getChild(UastNode.Kind.THEN);
            if (ifKeyword.isPresent() && condition.isPresent() && thenNode.isPresent()) {
                return new IfLike(node, ifKeyword.get(), condition.get(), thenNode.get(), ElseLike.from(node));
            }
        }
        return null;
    }

    public UastNode ifKeyword() {
        return this.ifKeyword;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode condition() {
        return this.condition;
    }

    public UastNode thenNode() {
        return this.thenNode;
    }

    @CheckForNull
    public ElseLike elseLike() {
        return this.elseLike;
    }

    @CheckForNull
    public IfLike elseIf() {
        return this.elseLike != null ? this.elseLike.elseIf() : null;
    }

    public static class ElseLike {
        private final UastNode elseKeyword;
        private final UastNode elseNode;

        private ElseLike(UastNode elseKeyword, UastNode elseNode) {
            this.elseKeyword = elseKeyword;
            this.elseNode = elseNode;
        }

        @CheckForNull
        private static ElseLike from(@Nullable UastNode node) {
            if (node == null) {
                return null;
            }
            if (node.is(UastNode.Kind.IF)) {
                Optional<UastNode> elseKeyword = node.getChild(UastNode.Kind.ELSE_KEYWORD);
                Optional<UastNode> elseNode = node.getChild(UastNode.Kind.ELSE);
                if (elseKeyword.isPresent() && elseNode.isPresent()) {
                    return new ElseLike(elseKeyword.get(), elseNode.get());
                }
            }
            return null;
        }

        public UastNode elseKeyword() {
            return this.elseKeyword;
        }

        public UastNode elseNode() {
            return this.elseNode;
        }

        @CheckForNull
        public IfLike elseIf() {
            return IfLike.from(this.elseNode);
        }
    }
}

