/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildSplatInstr
extends OneOperandResultBaseInstr {
    private final boolean dup;

    public BuildSplatInstr(Variable result2, Operand array, boolean dup2) {
        super(Operation.BUILD_SPLAT, result2, array);
        this.dup = dup2;
    }

    public boolean getDup() {
        return this.dup;
    }

    public Operand getArray() {
        return this.getOperand1();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildSplatInstr(ii.getRenamedVariable(this.result), this.getArray().cloneForInlining(ii), this.getDup());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return IRRuntimeHelpers.splatArray(context, (IRubyObject)this.getArray().retrieve(context, self2, currScope, currDynScope, temp), this.getDup());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArray());
        e.encode(this.getDup());
    }

    public static BuildSplatInstr decode(IRReaderDecoder d) {
        return new BuildSplatInstr(d.decodeVariable(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildSplatInstr(this);
    }
}

