/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SValue
extends Operand {
    private final Operand array;

    public SValue(Operand array) {
        this.array = array;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.SVALUE;
    }

    public Operand getArray() {
        return this.array;
    }

    @Override
    public boolean hasKnownValue() {
        return this.array.hasKnownValue();
    }

    public String toString() {
        return "SValue:" + this.array;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newArray = this.array.getSimplifiedOperand(valueMap, force);
        if (newArray instanceof Array) {
            Array a = (Array)newArray;
            return a.getElts().length == 1 ? a.getElts()[0] : a;
        }
        return newArray == this.array ? this : new SValue(newArray);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.array.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this.hasKnownValue() ? this : new SValue(this.array.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        Object val = this.array.retrieve(context, self2, currScope, currDynScope, temp);
        return val instanceof RubyArray ? val : context.nil;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArray());
    }

    public static SValue decode(IRReaderDecoder d) {
        return new SValue(d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SValue(this);
    }
}

