/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class ExternalReportProvider {
    private static final Logger LOG = Loggers.get(ExternalReportProvider.class);

    public static List<File> getReportFiles(SensorContext context, String externalReportsProperty) {
        boolean externalIssuesSupported = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)2));
        String[] reportPaths = context.config().getStringArray(externalReportsProperty);
        if (reportPaths.length == 0) {
            return Collections.emptyList();
        }
        if (!externalIssuesSupported) {
            LOG.error("Import of external issues requires SonarQube 7.2 or greater.");
            return Collections.emptyList();
        }
        ArrayList<File> result2 = new ArrayList<File>();
        for (String reportPath : reportPaths) {
            File report = ExternalReportProvider.getIOFile(context.fileSystem().baseDir(), reportPath);
            result2.add(report);
        }
        return result2;
    }

    private static File getIOFile(File baseDir, String path2) {
        File file2 = new File(path2);
        if (!file2.isAbsolute()) {
            file2 = new File(baseDir, path2);
        }
        return file2;
    }
}

