/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.exceptions.NoMethodError;
import org.jruby.exceptions.StandardError;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.specialized.RubyArrayTwoObject;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.ruby.converter.RubyVisitor;
import org.sonarsource.ruby.converter.adapter.CommentAdapter;
import org.sonarsource.ruby.converter.adapter.RangeAdapter;
import org.sonarsource.ruby.converter.adapter.TokenAdapter;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.ParseException;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.TextRanges;
import org.sonarsource.slang.impl.TopLevelTreeImpl;
import org.sonarsource.slang.impl.TreeMetaDataProvider;

public class RubyConverter
implements ASTConverter {
    private static final Logger LOG = Loggers.get(RubyConverter.class);
    private static final String SETUP_SCRIPT_PATH = "/whitequark_parser_init.rb";
    private static final String RACC_RUBYGEM_PATH = "/racc-1.4.13-java/lib";
    private static final String AST_RUBYGEM_PATH = "/ast-2.4.0/lib";
    private static final String PARSER_RUBYGEM_PATH = "/parser-2.5.1.2/lib";
    private static final String COMMENT_TOKEN_TYPE = "tCOMMENT";
    static final String FILENAME = "(SonarRuby analysis)";
    private final RubyRuntimeAdapter rubyRuntimeAdapter;
    private final Ruby runtime;

    RubyConverter(RubyRuntimeAdapter rubyRuntimeAdapter) {
        this.rubyRuntimeAdapter = rubyRuntimeAdapter;
        try {
            this.runtime = this.initializeRubyRuntime();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialized ruby runtime", e);
        }
    }

    public RubyConverter() {
        this(JavaEmbedUtils.newRuntimeAdapter());
    }

    @Override
    public void terminate() {
        if (this.runtime != null) {
            JavaEmbedUtils.terminate(this.runtime);
        }
    }

    @Override
    public Tree parse(String content) {
        try {
            return this.parseContent(content);
        }
        catch (StandardError e) {
            throw new ParseException(e.getMessage(), this.getErrorLocation(e), e);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), null, e);
        }
    }

    TextPointer getErrorLocation(StandardError e) {
        try {
            IRubyObject diagnostic = (IRubyObject)this.invokeMethod(e.getException(), "diagnostic", null);
            IRubyObject location = (IRubyObject)this.invokeMethod(diagnostic, "location", null);
            if (location != null) {
                return new RangeAdapter(this.runtime, location).toTextRange().start();
            }
        }
        catch (NoMethodError noMethodError) {
            // empty catch block
        }
        LOG.warn("No location information available for parse error");
        return null;
    }

    Tree parseContent(String content) {
        Object[] parameters2 = new Object[]{content, FILENAME};
        List rubyParseResult = (List)this.invokeMethod(this.runtime.getObject(), "parse_with_tokens", parameters2);
        if (rubyParseResult == null) {
            throw new ParseException("Unable to parse file content");
        }
        Object rubyAst = rubyParseResult.get(0);
        List rubyComments = (List)rubyParseResult.get(1);
        List rubyTokens = (List)rubyParseResult.get(2);
        List<Comment> comments = rubyComments.stream().map(rubyComment -> new CommentAdapter(this.runtime, (IRubyObject)rubyComment)).map(CommentAdapter::toSlangComment).collect(Collectors.toList());
        List<Token> tokens = rubyTokens.stream().map(rubyToken -> new TokenAdapter(this.runtime, (RubyArrayTwoObject)rubyToken)).filter(tokenAdapter -> !COMMENT_TOKEN_TYPE.equals(tokenAdapter.getTokenType().asJavaString())).map(TokenAdapter::toSlangToken).filter(Objects::nonNull).collect(Collectors.toList());
        TreeMetaDataProvider metaDataProvider = new TreeMetaDataProvider(comments, tokens);
        if (tokens.isEmpty() && comments.isEmpty()) {
            throw new ParseException("No AST node found");
        }
        Object[] visitParams = new Object[]{rubyAst, new RubyVisitor(metaDataProvider)};
        Tree tree = (Tree)this.invokeMethod(this.runtime.getObject(), "visit", visitParams);
        TreeMetaData topTreeMetaData = metaDataProvider.metaData(RubyConverter.getFullRange(tokens, comments));
        if (tree == null) {
            return new TopLevelTreeImpl(topTreeMetaData, Collections.emptyList(), comments);
        }
        return new TopLevelTreeImpl(topTreeMetaData, Collections.singletonList(tree), comments);
    }

    private static TextRange getFullRange(List<Token> tokens, List<Comment> comments) {
        if (comments.isEmpty()) {
            return TextRanges.merge(Arrays.asList(tokens.get(0).textRange(), tokens.get(tokens.size() - 1).textRange()));
        }
        if (tokens.isEmpty()) {
            return TextRanges.merge(Arrays.asList(comments.get(0).textRange(), comments.get(comments.size() - 1).textRange()));
        }
        return TextRanges.merge(Arrays.asList(tokens.get(0).textRange(), tokens.get(tokens.size() - 1).textRange(), comments.get(0).textRange(), comments.get(comments.size() - 1).textRange()));
    }

    @Nullable
    Object invokeMethod(@Nullable Object receiver2, String methodName, @Nullable Object[] args2) {
        return JavaEmbedUtils.invokeMethod(this.runtime, receiver2, methodName, args2, Object.class);
    }

    private Ruby initializeRubyRuntime() throws IOException {
        URL raccRubygem = RubyConverter.class.getResource(RACC_RUBYGEM_PATH);
        URL astRubygem = RubyConverter.class.getResource(AST_RUBYGEM_PATH);
        URL parserRubygem = RubyConverter.class.getResource(PARSER_RUBYGEM_PATH);
        URL initParserScriptUrl = RubyConverter.class.getResource(SETUP_SCRIPT_PATH);
        Ruby rubyRuntime = JavaEmbedUtils.initialize(Arrays.asList(raccRubygem.toString(), astRubygem.toString(), parserRubygem.toString()));
        System.setProperty("jruby.thread.pool.enabled", "true");
        String initParserScript = new String(RubyConverter.getBytes(initParserScriptUrl), StandardCharsets.UTF_8);
        this.rubyRuntimeAdapter.eval(rubyRuntime, initParserScript);
        return rubyRuntime;
    }

    private static byte[] getBytes(URL url) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = url.openStream();){
            byte[] buffer = new byte[8192];
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        return out.toByteArray();
    }
}

