/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;

public class SimpleCovSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(SimpleCovSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("SimpleCov Sensor for Ruby coverage").onlyOnLanguage("ruby");
    }

    public void execute(SensorContext context) {
        try {
            Map<Path, String> reports = SimpleCovSensor.getReportFilesAndContents(context);
            if (reports.isEmpty()) {
                return;
            }
            JSONParser parser = new JSONParser();
            HashMap<String, Map<Integer, Integer>> mergedCoverages = new HashMap<String, Map<Integer, Integer>>();
            for (Map.Entry<Path, String> report : reports.entrySet()) {
                try {
                    JSONObject parseResult = (JSONObject)parser.parse(report.getValue());
                    SimpleCovSensor.mergeFileCoverages(mergedCoverages, parseResult.entrySet());
                }
                catch (Exception e) {
                    LOG.error("Cannot read coverage report file, expecting standard SimpleCov resultset JSON format: '{}'", (Object)report.getKey(), (Object)e);
                }
            }
            SimpleCovSensor.saveCoverage(context, mergedCoverages);
        }
        catch (IOException e) {
            LOG.error("Error reading coverage reports", (Throwable)e);
        }
    }

    private static void saveCoverage(SensorContext context, Map<String, Map<Integer, Integer>> mergedCoverages) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicates predicates = fileSystem.predicates();
        for (Map.Entry<String, Map<Integer, Integer>> coverageForFile : mergedCoverages.entrySet()) {
            String filePath = coverageForFile.getKey();
            InputFile inputFile = fileSystem.inputFile(predicates.hasAbsolutePath(filePath));
            if (inputFile != null) {
                try {
                    SimpleCovSensor.saveNewCoverage(context, coverageForFile.getValue(), inputFile);
                }
                catch (IllegalStateException e) {
                    LOG.error("Invalid coverage information on file: '{}'", (Object)filePath, (Object)e);
                }
                continue;
            }
            LOG.warn("File '{}' is present in coverage report but cannot be found in filesystem", (Object)filePath);
        }
    }

    private static void saveNewCoverage(SensorContext context, Map<Integer, Integer> hitsPerLines, InputFile inputFile) {
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
        for (Map.Entry<Integer, Integer> hitsPerLine : hitsPerLines.entrySet()) {
            newCoverage.lineHits(hitsPerLine.getKey().intValue(), hitsPerLine.getValue().intValue());
        }
        newCoverage.save();
    }

    private static void mergeFileCoverages(Map<String, Map<Integer, Integer>> coveragePerFiles, Set<Map.Entry<String, JSONObject>> testFrameworkResults) {
        for (Map.Entry<String, JSONObject> testFrameworkResult : testFrameworkResults) {
            JSONObject testFrameworkCoverage = (JSONObject)testFrameworkResult.getValue().get("coverage");
            Set<Map.Entry<String, JSONArray>> testFrameworkCoveragePerFiles = testFrameworkCoverage.entrySet();
            SimpleCovSensor.mergeFrameworkCoverages(coveragePerFiles, testFrameworkCoveragePerFiles);
        }
    }

    private static void mergeFrameworkCoverages(Map<String, Map<Integer, Integer>> coveragePerFiles, Set<Map.Entry<String, JSONArray>> testFrameworkCoveragePerFiles) {
        for (Map.Entry<String, JSONArray> coveragePerFile : testFrameworkCoveragePerFiles) {
            Map fileCoverage = coveragePerFiles.computeIfAbsent(coveragePerFile.getKey(), key2 -> new HashMap());
            JSONArray hitsPerLine = coveragePerFile.getValue();
            for (int i2 = 0; i2 < hitsPerLine.size(); ++i2) {
                Long hits = (Long)hitsPerLine.get(i2);
                if (hits == null) continue;
                int line = i2 + 1;
                Integer currentHits = fileCoverage.getOrDefault(line, 0);
                fileCoverage.put(line, currentHits + hits.intValue());
            }
        }
    }

    private static Map<Path, String> getReportFilesAndContents(SensorContext context) throws IOException {
        HashMap<Path, String> reports = new HashMap<Path, String>();
        Configuration config = context.config();
        FileSystem fs = context.fileSystem();
        for (String reportPath : config.getStringArray("sonar.ruby.coverage.reportPaths")) {
            String trimmedPath = reportPath.trim();
            String report = SimpleCovSensor.fileContent(fs, trimmedPath);
            if (report != null) {
                reports.put(Paths.get(trimmedPath, new String[0]), report);
                continue;
            }
            if (!config.hasKey("sonar.ruby.coverage.reportPaths")) continue;
            LOG.error("SimpleCov report not found: '{}'", (Object)trimmedPath);
        }
        return reports;
    }

    @CheckForNull
    private static String fileContent(FileSystem fs, String reportPath) throws IOException {
        InputFile report = fs.inputFile(fs.predicates().hasPath(reportPath));
        if (report != null && report.isFile()) {
            return report.contents();
        }
        File reportFile = fs.resolvePath(reportPath);
        if (reportFile.isFile()) {
            return new String(Files.readAllBytes(reportFile.toPath()), StandardCharsets.UTF_8);
        }
        return null;
    }
}

