/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import org.sonar.check.Rule;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextRangeImpl;

@Rule(key="S126")
public class ElseIfWithoutElseCheck
implements SlangCheck {
    private static final String MESSAGE = "Add the missing \"else\" clause.";

    @Override
    public void initialize(InitContext init) {
        init.register(IfTree.class, (ctx, ifTree) -> {
            IfTree nestedIfTree;
            Tree elseBranch = ifTree.elseBranch();
            if (elseBranch instanceof IfTree && (nestedIfTree = (IfTree)elseBranch).elseBranch() == null) {
                Token elseToken = ifTree.elseKeyword();
                Token ifToken = nestedIfTree.ifKeyword();
                TextRangeImpl textRange = new TextRangeImpl(elseToken.textRange().start(), ifToken.textRange().end());
                ctx.reportIssue(textRange, MESSAGE);
            }
        });
    }
}

