/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.text.MessageFormat;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.impl.TextRangeImpl;

@Rule(key="S103")
public class TooLongLineCheck
implements SlangCheck {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 200;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="200")
    int maximumLineLength = 200;
    private static final String MESSAGE = "Split this {0} characters long line (which is greater than {1} authorized).";

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, topLevelTree) -> {
            String[] lines2 = ctx.fileContent().split("\r\n|\n|\r", -1);
            IntStream.range(0, lines2.length).filter(lineNumber -> lines2[lineNumber].length() > this.maximumLineLength).forEach(lineNumber -> {
                int lineLength = lines2[lineNumber].length();
                TextRange longLine = TooLongLineCheck.getLineRange(lineNumber + 1, lineLength);
                ctx.reportIssue(longLine, MessageFormat.format(MESSAGE, lineLength, this.maximumLineLength));
            });
        });
    }

    private static TextRange getLineRange(int lineNumber, int lineLength) {
        return new TextRangeImpl(new TextPointerImpl(lineNumber, 0), new TextPointerImpl(lineNumber, lineLength));
    }
}

