/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.IfTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.BaseTreeImpl;

public class IfTreeImpl
extends BaseTreeImpl
implements IfTree {
    private final Tree condition;
    private final Tree thenBranch;
    private final Tree elseBranch;
    private final Token ifKeyword;
    private final Token elseKeyword;

    public IfTreeImpl(TreeMetaData metaData, Tree condition, Tree thenBranch, @Nullable Tree elseBranch, Token ifKeyword, @Nullable Token elseKeyword) {
        super(metaData);
        this.condition = condition;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
        this.ifKeyword = ifKeyword;
        this.elseKeyword = elseKeyword;
    }

    @Override
    public Tree condition() {
        return this.condition;
    }

    @Override
    public Tree thenBranch() {
        return this.thenBranch;
    }

    @Override
    @CheckForNull
    public Tree elseBranch() {
        return this.elseBranch;
    }

    @Override
    public Token ifKeyword() {
        return this.ifKeyword;
    }

    @Override
    @CheckForNull
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children2 = new ArrayList<Tree>();
        children2.add(this.condition);
        children2.add(this.thenBranch);
        if (this.elseBranch != null) {
            children2.add(this.elseBranch);
        }
        return children2;
    }
}

