/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.css.plugin.LinterCommandProvider;
import org.sonarsource.nodejs.NodeCommand;

@ScannerSide
public class StylelintCommandProvider
implements LinterCommandProvider {
    private static final String CONFIG_PATH = "css-bundle/stylelintconfig.json";
    private static final List<String> LANGUAGES_TO_ANALYZE = Arrays.asList("css", "html", "php");

    @Override
    public NodeCommand nodeCommand(File deployDestination, SensorContext context, Consumer<String> output, Consumer<String> error) {
        String projectBaseDir = context.fileSystem().baseDir().getAbsolutePath();
        List suffixes = LANGUAGES_TO_ANALYZE.stream().map(language -> context.config().getStringArray("sonar." + language + ".file.suffixes")).flatMap(Stream::of).collect(Collectors.toList());
        String filesGlob = "**" + File.separator + "*{" + String.join((CharSequence)",", suffixes) + "}";
        String filesToAnalyze = Paths.get(projectBaseDir, "TOREPLACE").toString();
        filesToAnalyze = filesToAnalyze.replace("TOREPLACE", filesGlob);
        String[] args = new String[]{new File(deployDestination, "css-bundle/node_modules/stylelint/bin/stylelint").getAbsolutePath(), filesToAnalyze, "--config", new File(deployDestination, CONFIG_PATH).getAbsolutePath(), "-f", "json"};
        return NodeCommand.builder().outputConsumer(output).errorConsumer(error).minNodeVersion(6).configuration(context.config()).nodeJsArgs(args).build();
    }

    @Override
    public String configPath(File deployDestination) {
        return new File(deployDestination, CONFIG_PATH).getAbsolutePath();
    }
}

