/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.bundle;

import java.io.File;
import java.io.InputStream;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.Zip;
import org.sonar.css.plugin.bundle.BundleHandler;

@ScannerSide
public class CssBundleHandler
implements BundleHandler {
    private static final String BUNDLE_LOCATION = "/css-bundle.zip";
    private static final Logger LOG = Loggers.get(CssBundleHandler.class);
    String bundleLocation = "/css-bundle.zip";

    @Override
    public void deployBundle(File deployDestination) {
        InputStream bundle = this.getClass().getResourceAsStream(this.bundleLocation);
        if (bundle == null) {
            throw new IllegalStateException("CSS bundle not found at " + this.bundleLocation);
        }
        try {
            LOG.debug("Deploying bundle to {}", (Object)deployDestination.getAbsolutePath());
            Zip.extract(bundle, deployDestination);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deploy CSS bundle (with classpath '" + this.bundleLocation + "')", e);
        }
    }
}

