/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;

public class RuleMetadataLoader {
    private static final char RESOURCE_SEP = '/';
    private final String resourceFolder;
    private final Set<String> activatedByDefault;
    private JsonParser jsonParser;

    public RuleMetadataLoader(String resourceFolder) {
        this(resourceFolder, Collections.emptySet());
    }

    public RuleMetadataLoader(String resourceFolder, String defaultProfilePath) {
        this(resourceFolder, BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(defaultProfilePath));
    }

    private RuleMetadataLoader(String resourceFolder, Set<String> activatedByDefault) {
        this.resourceFolder = resourceFolder;
        this.jsonParser = new JsonParser();
        this.activatedByDefault = activatedByDefault;
    }

    public void addRulesByAnnotatedClass(RulesDefinition.NewRepository repository, List<Class> ruleClasses) {
        for (Class ruleClass : ruleClasses) {
            this.addRuleByAnnotatedClass(repository, ruleClass);
        }
    }

    public void addRulesByRuleKey(RulesDefinition.NewRepository repository, List<String> ruleKeys) {
        for (String ruleKey : ruleKeys) {
            this.addRuleByRuleKey(repository, ruleKey);
        }
    }

    private RulesDefinition.NewRule addRuleByAnnotatedClass(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        RulesDefinition.NewRule rule = RuleMetadataLoader.addAnnotatedRule(repository, ruleClass);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
        return rule;
    }

    private void setDefaultActivation(RulesDefinition.NewRule rule) {
        if (this.activatedByDefault.contains(rule.key())) {
            rule.setActivatedByDefault(true);
        }
    }

    private static RulesDefinition.NewRule addAnnotatedRule(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalStateException("No Rule annotation was found on " + ruleClass.getName());
        }
        String ruleKey = ruleAnnotation.key();
        if (ruleKey.length() == 0) {
            throw new IllegalStateException("Empty key");
        }
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, new Class[]{ruleClass});
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("Rule not found: " + ruleKey);
        }
        return rule;
    }

    private RulesDefinition.NewRule addRuleByRuleKey(RulesDefinition.NewRepository repository, String ruleKey) {
        if (ruleKey.length() == 0) {
            throw new IllegalStateException("Empty key");
        }
        RulesDefinition.NewRule rule = repository.createRule(ruleKey);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
        return rule;
    }

    private void setDescriptionFromHtml(RulesDefinition.NewRule rule) {
        String description;
        String htmlPath = this.resourceFolder + '/' + rule.key() + ".html";
        try {
            description = Resources.toString(htmlPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + htmlPath, e);
        }
        rule.setHtmlDescription(description);
    }

    private void setMetadataFromJson(RulesDefinition.NewRule rule) {
        Map<String, Object> root;
        String jsonPath = this.resourceFolder + '/' + rule.key() + ".json";
        try {
            root = this.jsonParser.parse(Resources.toString(jsonPath, StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Can't read resource: " + jsonPath, e);
        }
        rule.setName(RuleMetadataLoader.getString(root, "title"));
        rule.setSeverity(RuleMetadataLoader.getUpperCaseString(root, "defaultSeverity"));
        rule.setType(RuleType.valueOf((String)RuleMetadataLoader.getUpperCaseString(root, "type")));
        rule.setStatus(RuleStatus.valueOf((String)RuleMetadataLoader.getUpperCaseString(root, "status")));
        rule.setTags(RuleMetadataLoader.getStringArray(root, "tags"));
        Object remediation = root.get("remediation");
        if (remediation != null) {
            RuleMetadataLoader.setRemediationFromJson(rule, (Map)remediation);
        }
    }

    private static void setRemediationFromJson(RulesDefinition.NewRule rule, Map<String, Object> remediation) {
        String func = RuleMetadataLoader.getString(remediation, "func");
        RulesDefinition.DebtRemediationFunctions remediationBuilder = rule.debtRemediationFunctions();
        if (func.startsWith("Constant")) {
            String constantCost = RuleMetadataLoader.getString(remediation, "constantCost");
            rule.setDebtRemediationFunction(remediationBuilder.constantPerIssue(constantCost.replace("mn", "min")));
        } else if ("Linear".equals(func)) {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            rule.setDebtRemediationFunction(remediationBuilder.linear(linearFactor.replace("mn", "min")));
        } else {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            String linearOffset = RuleMetadataLoader.getString(remediation, "linearOffset");
            rule.setDebtRemediationFunction(remediationBuilder.linearWithOffset(linearFactor.replace("mn", "min"), linearOffset.replace("mn", "min")));
        }
        if (remediation.get("linearDesc") != null) {
            rule.setGapDescription(RuleMetadataLoader.getString(remediation, "linearDesc"));
        }
    }

    private static String getUpperCaseString(Map<String, Object> map, String propertyName) {
        return RuleMetadataLoader.getString(map, propertyName).toUpperCase(Locale.ROOT);
    }

    private static String getString(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (propertyValue == null || !(propertyValue instanceof String)) {
            throw new IllegalStateException("Invalid property '" + propertyName + "'");
        }
        return (String)propertyValue;
    }

    static String[] getStringArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (propertyValue == null || !(propertyValue instanceof List)) {
            throw new IllegalStateException("Invalid property: " + propertyName);
        }
        return ((List)propertyValue).toArray(new String[0]);
    }
}

