/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.NodeCommand;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandException;

class NodeCommandBuilderImpl
implements NodeCommandBuilder {
    private static final Logger LOG = Loggers.get(NodeCommandBuilderImpl.class);
    private static final String NODE_EXECUTABLE_DEFAULT = "node";
    private static final String NODE_EXECUTABLE_PROPERTY = "sonar.nodejs.executable";
    private static final Pattern NODEJS_VERSION_PATTERN = Pattern.compile("v?(\\d+)\\.\\d+\\.\\d+");
    private final NodeCommand.ProcessWrapper processWrapper;
    private Integer minNodeVersion;
    private Configuration configuration;
    private List<String> args = new ArrayList<String>();
    private List<String> nodeJsArgs = new ArrayList<String>();
    private Consumer<String> outputConsumer = arg_0 -> ((Logger)LOG).info(arg_0);
    private Consumer<String> errorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
    private String scriptFilename;

    NodeCommandBuilderImpl(NodeCommand.ProcessWrapper processWrapper) {
        this.processWrapper = processWrapper;
    }

    @Override
    public NodeCommandBuilder minNodeVersion(int minNodeVersion) {
        this.minNodeVersion = minNodeVersion;
        return this;
    }

    @Override
    public NodeCommandBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public NodeCommandBuilder maxOldSpaceSize(int maxOldSpaceSize) {
        this.nodeJsArgs("--max-old-space-size=" + maxOldSpaceSize);
        return this;
    }

    @Override
    public NodeCommandBuilder nodeJsArgs(String ... nodeJsArgs) {
        this.nodeJsArgs.addAll(Arrays.asList(nodeJsArgs));
        return this;
    }

    @Override
    public NodeCommandBuilder script(String scriptFilename) {
        this.scriptFilename = scriptFilename;
        return this;
    }

    @Override
    public NodeCommandBuilder scriptArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public NodeCommandBuilder outputConsumer(Consumer<String> consumer) {
        this.outputConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommandBuilder errorConsumer(Consumer<String> consumer) {
        this.errorConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommand build() throws NodeCommandException {
        String nodeExecutable = NodeCommandBuilderImpl.retrieveNodeExecutableFromConfig(this.configuration);
        this.checkNodeCompatibility(nodeExecutable);
        if (this.nodeJsArgs.isEmpty() && this.scriptFilename == null && this.args.isEmpty()) {
            throw new IllegalArgumentException("Missing arguments for Node.js.");
        }
        if (this.scriptFilename == null && !this.args.isEmpty()) {
            throw new IllegalArgumentException("No script provided, but script arguments found.");
        }
        return new NodeCommand(this.processWrapper, nodeExecutable, this.nodeJsArgs, this.scriptFilename, this.args, this.outputConsumer, this.errorConsumer);
    }

    private void checkNodeCompatibility(String nodeExecutable) throws NodeCommandException {
        if (this.minNodeVersion == null) {
            return;
        }
        LOG.debug("Checking Node.js version");
        String actualVersion = this.getVersion(nodeExecutable);
        boolean isCompatible = NodeCommandBuilderImpl.checkVersion(actualVersion, this.minNodeVersion);
        if (!isCompatible) {
            throw new NodeCommandException(String.format("Only Node.js v%s or later is supported, got %s.", this.minNodeVersion, actualVersion));
        }
        LOG.debug("Using Node.js {}.", (Object)actualVersion);
    }

    @VisibleForTesting
    static boolean checkVersion(String actualVersion, int requiredVersion) throws NodeCommandException {
        Matcher versionMatcher = NODEJS_VERSION_PATTERN.matcher(actualVersion);
        if (versionMatcher.lookingAt()) {
            int major = Integer.parseInt(versionMatcher.group(1));
            return major >= requiredVersion;
        }
        throw new NodeCommandException("Failed to parse Node.js version, got '" + actualVersion + "'");
    }

    private String getVersion(String nodeExecutable) throws NodeCommandException {
        StringBuilder output = new StringBuilder();
        NodeCommand nodeCommand = new NodeCommand(this.processWrapper, nodeExecutable, Collections.singletonList("-v"), null, Collections.emptyList(), output::append, arg_0 -> ((Logger)LOG).error(arg_0));
        nodeCommand.start();
        int exitValue = nodeCommand.waitFor();
        if (exitValue != 0) {
            throw new NodeCommandException("Failed to determine the version of Node.js, exit value " + exitValue + ". Executed: '" + nodeCommand.toString() + "'");
        }
        return output.toString();
    }

    private static String retrieveNodeExecutableFromConfig(@Nullable Configuration configuration) throws NodeCommandException {
        if (configuration != null && configuration.hasKey(NODE_EXECUTABLE_PROPERTY)) {
            String nodeExecutable = (String)configuration.get(NODE_EXECUTABLE_PROPERTY).get();
            File file = new File(nodeExecutable);
            if (file.exists()) {
                LOG.info("Using Node.js executable {} from property {}.", (Object)file.getAbsoluteFile(), (Object)NODE_EXECUTABLE_PROPERTY);
                return nodeExecutable;
            }
            LOG.error("Provided Node.js executable file does not exist. Property '{}' was to '{}'", (Object)NODE_EXECUTABLE_PROPERTY, (Object)nodeExecutable);
            throw new NodeCommandException("Provided Node.js executable file does not exist.");
        }
        LOG.debug("Using default Node.js executable: '{}'.", (Object)NODE_EXECUTABLE_DEFAULT);
        return NODE_EXECUTABLE_DEFAULT;
    }
}

