/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.step;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.CeTaskInterrupter;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.ce.task.step.ComputationSteps;
import org.sonar.core.util.logs.Profiler;

public final class ComputationStepExecutor {
    private static final Logger LOGGER = Loggers.get(ComputationStepExecutor.class);
    private final ComputationSteps steps;
    private final CeTaskInterrupter taskInterrupter;
    @CheckForNull
    private final Listener listener;

    public ComputationStepExecutor(ComputationSteps steps, CeTaskInterrupter taskInterrupter) {
        this(steps, taskInterrupter, null);
    }

    public ComputationStepExecutor(ComputationSteps steps, CeTaskInterrupter taskInterrupter, @Nullable Listener listener) {
        this.steps = steps;
        this.taskInterrupter = taskInterrupter;
        this.listener = listener;
    }

    public void execute() {
        Profiler stepProfiler = Profiler.create((Logger)LOGGER).logTimeLast(true);
        boolean allStepsExecuted = false;
        try {
            this.executeSteps(stepProfiler);
            allStepsExecuted = true;
        }
        finally {
            if (this.listener != null) {
                this.executeListener(allStepsExecuted);
            }
        }
    }

    private void executeSteps(Profiler stepProfiler) {
        StepStatisticsImpl statistics = new StepStatisticsImpl(stepProfiler);
        StepContextImpl context = new StepContextImpl(statistics);
        for (ComputationStep step : this.steps.instances()) {
            this.executeStep(stepProfiler, context, step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStep(Profiler stepProfiler, ComputationStep.Context context, ComputationStep step) {
        String status = "FAILED";
        stepProfiler.start();
        try {
            this.taskInterrupter.check(Thread.currentThread());
            step.execute(context);
            status = "SUCCESS";
        }
        finally {
            stepProfiler.addContext("status", (Object)status);
            stepProfiler.stopInfo(step.getDescription());
        }
    }

    private void executeListener(boolean allStepsExecuted) {
        try {
            this.listener.finished(allStepsExecuted);
        }
        catch (Throwable e) {
            LOGGER.error("Execution of listener failed", e);
        }
    }

    private static class StepContextImpl
    implements ComputationStep.Context {
        private final ComputationStep.Statistics statistics;

        private StepContextImpl(ComputationStep.Statistics statistics) {
            this.statistics = statistics;
        }

        @Override
        public ComputationStep.Statistics getStatistics() {
            return this.statistics;
        }
    }

    private static class StepStatisticsImpl
    implements ComputationStep.Statistics {
        private final Profiler profiler;

        private StepStatisticsImpl(Profiler profiler) {
            this.profiler = profiler;
        }

        @Override
        public ComputationStep.Statistics add(String key, Object value) {
            Objects.requireNonNull(key, "Statistic has null key");
            Objects.requireNonNull(value, () -> String.format("Statistic with key [%s] has null value", key));
            Preconditions.checkArgument((!key.equalsIgnoreCase("time") ? 1 : 0) != 0, (Object)"Statistic with key [time] is not accepted");
            Preconditions.checkArgument((!this.profiler.hasContext(key) ? 1 : 0) != 0, (String)"Statistic with key [%s] is already present", (Object[])new Object[]{key});
            this.profiler.addContext(key, value);
            return this;
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void finished(boolean var1);
    }
}

