/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import org.sonar.core.issue.tracking.FilteringBaseInputWrapper;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.core.issue.tracking.Tracking;

public class NonClosedTracking<RAW extends Trackable, BASE extends Trackable>
extends Tracking<RAW, BASE> {
    private final Input<RAW> rawInput;
    private final Input<BASE> baseInput;

    private NonClosedTracking(Input<RAW> rawInput, Input<BASE> baseInput) {
        super(rawInput.getIssues(), baseInput.getIssues());
        this.rawInput = rawInput;
        this.baseInput = baseInput;
    }

    public static <RAW extends Trackable, BASE extends Trackable> NonClosedTracking<RAW, BASE> of(Input<RAW> rawInput, Input<BASE> baseInput) {
        FilteringBaseInputWrapper<Trackable> nonClosedBaseInput = new FilteringBaseInputWrapper<Trackable>(baseInput, t -> !"CLOSED".equals(t.getStatus()));
        return new NonClosedTracking<RAW, Trackable>(rawInput, nonClosedBaseInput);
    }

    Input<RAW> getRawInput() {
        return this.rawInput;
    }

    Input<BASE> getBaseInput() {
        return this.baseInput;
    }
}

