/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.Plugin;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginClassLoaderDef;
import org.sonar.core.platform.PluginClassloaderFactory;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.updatecenter.common.Version;

public class PluginLoader {
    private static final String[] DEFAULT_SHARED_RESOURCES = new String[]{"org/sonar/plugins", "com/sonar/plugins", "com/sonarsource/plugins"};
    private static final Version COMPATIBILITY_MODE_MAX_VERSION = Version.create((String)"5.2");
    private final PluginJarExploder jarExploder;
    private final PluginClassloaderFactory classloaderFactory;

    public PluginLoader(PluginJarExploder jarExploder, PluginClassloaderFactory classloaderFactory) {
        this.jarExploder = jarExploder;
        this.classloaderFactory = classloaderFactory;
    }

    public Map<String, Plugin> load(Map<String, PluginInfo> infoByKeys) {
        Collection<PluginClassLoaderDef> defs = this.defineClassloaders(infoByKeys);
        Map<PluginClassLoaderDef, ClassLoader> classloaders = this.classloaderFactory.create(defs);
        return this.instantiatePluginClasses(classloaders);
    }

    @VisibleForTesting
    Collection<PluginClassLoaderDef> defineClassloaders(Map<String, PluginInfo> infoByKeys) {
        HashMap<String, PluginClassLoaderDef> classloadersByBasePlugin = new HashMap<String, PluginClassLoaderDef>();
        for (PluginInfo info : infoByKeys.values()) {
            String baseKey = PluginLoader.basePluginKey(info, infoByKeys);
            PluginClassLoaderDef def = (PluginClassLoaderDef)classloadersByBasePlugin.get(baseKey);
            if (def == null) {
                def = new PluginClassLoaderDef(baseKey);
                classloadersByBasePlugin.put(baseKey, def);
            }
            ExplodedPlugin explodedPlugin = this.jarExploder.explode(info);
            def.addFiles(Arrays.asList(explodedPlugin.getMain()));
            def.addFiles(explodedPlugin.getLibs());
            def.addMainClass(info.getKey(), info.getMainClass());
            for (String defaultSharedResource : DEFAULT_SHARED_RESOURCES) {
                def.getExportMask().addInclusion(String.format("%s/%s/api/", defaultSharedResource, info.getKey()));
            }
            if (!Strings.isNullOrEmpty((String)info.getBasePlugin())) continue;
            if (info.isUseChildFirstClassLoader()) {
                Loggers.get(this.getClass()).warn("Plugin {} [{}] uses a child first classloader which is deprecated", (Object)info.getName(), (Object)info.getKey());
            }
            def.setSelfFirstStrategy(info.isUseChildFirstClassLoader());
            Version minSqVersion = info.getMinimalSqVersion();
            boolean compatibilityMode = minSqVersion != null && minSqVersion.compareToIgnoreQualifier(COMPATIBILITY_MODE_MAX_VERSION) < 0;
            if (!compatibilityMode) continue;
            Loggers.get(this.getClass()).warn("API compatibility mode is no longer supported. In case of error, plugin {} [{}] should package its dependencies.", (Object)info.getName(), (Object)info.getKey());
        }
        return classloadersByBasePlugin.values();
    }

    @VisibleForTesting
    Map<String, Plugin> instantiatePluginClasses(Map<PluginClassLoaderDef, ClassLoader> classloaders) {
        HashMap<String, Plugin> instancesByPluginKey = new HashMap<String, Plugin>();
        for (Map.Entry<PluginClassLoaderDef, ClassLoader> entry : classloaders.entrySet()) {
            PluginClassLoaderDef def = entry.getKey();
            ClassLoader classLoader = entry.getValue();
            for (Map.Entry<String, String> mainClassEntry : def.getMainClassesByPluginKey().entrySet()) {
                String pluginKey = mainClassEntry.getKey();
                String mainClass = mainClassEntry.getValue();
                try {
                    instancesByPluginKey.put(pluginKey, (Plugin)classLoader.loadClass(mainClass).newInstance());
                }
                catch (UnsupportedClassVersionError e) {
                    throw new IllegalStateException(String.format("The plugin [%s] does not support Java %s", pluginKey, SystemUtils.JAVA_VERSION_TRIMMED), e);
                }
                catch (Throwable e) {
                    throw new IllegalStateException(String.format("Fail to instantiate class [%s] of plugin [%s]", mainClass, pluginKey), e);
                }
            }
        }
        return instancesByPluginKey;
    }

    public void unload(Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            if (!(classLoader instanceof Closeable) || classLoader == this.classloaderFactory.baseClassLoader()) continue;
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                Loggers.get(this.getClass()).error("Fail to close classloader " + classLoader.toString(), (Throwable)e);
            }
        }
    }

    static String basePluginKey(PluginInfo plugin, Map<String, PluginInfo> allPluginsPerKey) {
        String base = plugin.getKey();
        String parentKey = plugin.getBasePlugin();
        while (!Strings.isNullOrEmpty((String)parentKey)) {
            PluginInfo parentPlugin = allPluginsPerKey.get(parentKey);
            base = parentPlugin.getKey();
            parentKey = parentPlugin.getBasePlugin();
        }
        return base;
    }
}

