/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.xpath;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.jaxen.DefaultNavigator;
import org.jaxen.XPath;
import org.jaxen.util.SingleObjectIterator;

public class AstNodeNavigator
extends DefaultNavigator {
    private transient AstNode documentNode = null;

    public void reset() {
        this.documentNode = null;
    }

    @Override
    public String getTextStringValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCommentStringValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeStringValue(Object attributeObject) {
        Attribute attribute = (Attribute)attributeObject;
        if ("tokenLine".equals(attribute.getName())) {
            return Integer.toString(attribute.getAstNode().getToken().getLine());
        }
        if ("tokenColumn".equals(attribute.getName())) {
            return Integer.toString(attribute.getAstNode().getToken().getColumn());
        }
        if ("tokenValue".equals(attribute.getName())) {
            return attribute.getAstNode().getToken().getValue();
        }
        throw new UnsupportedOperationException("Unsupported attribute name \"" + attribute.getName() + "\"");
    }

    @Override
    public String getElementStringValue(Object arg0) {
        throw new UnsupportedOperationException("Implicit nodes to string conversion is not supported. Use the tokenValue attribute instead.");
    }

    @Override
    public String getNamespacePrefix(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceStringValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeName(Object attributeObject) {
        Attribute attribute = (Attribute)attributeObject;
        return attribute.getName();
    }

    @Override
    public String getAttributeQName(Object attributeObject) {
        return this.getAttributeName(attributeObject);
    }

    @Override
    public String getAttributeNamespaceUri(Object arg0) {
        return "";
    }

    @Override
    public String getElementName(Object astNodeObject) {
        AstNode astNode = (AstNode)astNodeObject;
        return astNode.getName();
    }

    @Override
    public String getElementQName(Object astNodeObject) {
        return this.getElementName(astNodeObject);
    }

    @Override
    public String getElementNamespaceUri(Object astNodeObject) {
        return "";
    }

    @Override
    public boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    @Override
    public boolean isComment(Object object) {
        return false;
    }

    @Override
    public boolean isDocument(Object contextObject) {
        this.computeDocumentNode(contextObject);
        return this.documentNode == null ? false : this.documentNode.equals(contextObject);
    }

    @Override
    public boolean isElement(Object object) {
        return object instanceof AstNode;
    }

    @Override
    public boolean isNamespace(Object arg0) {
        return false;
    }

    @Override
    public boolean isProcessingInstruction(Object arg0) {
        return false;
    }

    @Override
    public boolean isText(Object arg0) {
        return false;
    }

    private void computeDocumentNode(Object contextNode) {
        if (this.documentNode == null) {
            if (this.isElement(contextNode)) {
                AstNode root = (AstNode)contextNode;
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                this.documentNode = new AstNode(null, "[root]", null);
                this.documentNode.addChild(root);
            } else if (this.isAttribute(contextNode)) {
                Attribute attribute = (Attribute)contextNode;
                this.computeDocumentNode(attribute.getAstNode());
            }
        }
    }

    @Override
    public Object getDocumentNode(Object contextNode) {
        this.computeDocumentNode(contextNode);
        Objects.requireNonNull(this.documentNode, "Unable to compute the document node from the context node \"" + contextNode.getClass().getSimpleName() + "\": " + contextNode);
        return this.documentNode;
    }

    @Override
    public Iterator getChildAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            AstNode astNode = (AstNode)contextNode;
            return astNode.getChildren().iterator();
        }
        if (this.isAttribute(contextNode)) {
            return Collections.emptyIterator();
        }
        throw new UnsupportedOperationException("Unsupported context object type for child axis \"" + contextNode.getClass().getSimpleName() + "\": " + contextNode);
    }

    @Override
    public Object getParentNode(Object contextNode) {
        if (this.isElement(contextNode)) {
            AstNode astNode = (AstNode)contextNode;
            return astNode.getParent();
        }
        if (this.isAttribute(contextNode)) {
            Attribute attribute = (Attribute)contextNode;
            return attribute.getAstNode();
        }
        throw new UnsupportedOperationException("Unsupported context object type for parent node \"" + contextNode.getClass().getSimpleName() + "\": " + contextNode);
    }

    @Override
    public Iterator getParentAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            AstNode astNode = (AstNode)contextNode;
            AstNode parent = astNode.getParent();
            return parent == null ? Collections.emptyIterator() : new SingleObjectIterator(parent);
        }
        if (this.isAttribute(contextNode)) {
            Attribute attribute = (Attribute)contextNode;
            return new SingleObjectIterator(attribute.getAstNode());
        }
        throw new UnsupportedOperationException("Unsupported context object type for parent axis \"" + contextNode.getClass().getSimpleName() + "\": " + contextNode);
    }

    @Override
    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            AstNode astNode = (AstNode)contextNode;
            if (!astNode.hasToken()) {
                return Collections.emptyIterator();
            }
            return Arrays.asList(new Attribute("tokenLine", astNode), new Attribute("tokenColumn", astNode), new Attribute("tokenValue", astNode)).iterator();
        }
        if (this.isAttribute(contextNode)) {
            return Collections.emptyIterator();
        }
        throw new UnsupportedOperationException("Unsupported context object type for attribute axis \"" + contextNode.getClass().getSimpleName() + "\": " + contextNode);
    }

    @Override
    public XPath parseXPath(String arg0) {
        return null;
    }

    public static class Attribute {
        private final String name;
        private final AstNode astNode;

        public Attribute(String name, AstNode astNode) {
            this.name = name;
            this.astNode = astNode;
        }

        public String getName() {
            return this.name;
        }

        public AstNode getAstNode() {
            return this.astNode;
        }
    }
}

