/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="ActionScript2")
public class ActionScript2Check
extends FlexCheck {
    private final Set<String> deprecatedOperators = ImmutableSet.of("or", "and", "ne", "eq", "ge", "gt", new String[]{"le", "lt", "add", "<>"});

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.UNARY_EXPR, FlexGrammar.LOGICAL_OR_OPERATOR, FlexGrammar.LOGICAL_AND_OPERATOR, FlexGrammar.EQUALITY_OPERATOR, FlexGrammar.RELATIONAL_OPERATOR, FlexGrammar.RELATIONAL_OPERATOR_NO_IN, FlexGrammar.ADDITIVE_OPERATOR);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.UNARY_EXPR) && "not".equals(astNode.getFirstChild().getTokenValue())) {
            this.addIssue("Operator 'not' not available in ActionScript 3.0", astNode.getFirstChild());
        } else {
            String operator = ActionScript2Check.getValue(astNode);
            if (this.deprecatedOperators.contains(operator)) {
                this.addIssue("Operator '" + operator + "' not available in ActionScript 3.0", astNode);
            }
        }
    }

    private static String getValue(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : astNode.getChildren()) {
            sb.append(child.getTokenValue());
        }
        return sb.toString();
    }
}

