/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;

@Rule(key="S1125")
public class BooleanEqualityComparisonCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.EQUALITY_EXPR);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (BooleanEqualityComparisonCheck.hasBooleanLiteralOperand(astNode.getFirstChild(FlexGrammar.EQUALITY_OPERATOR).getNextAstNode())) {
            this.addIssue("Remove the unnecessary boolean comparison to simplify this expression.", astNode);
        }
    }

    private static boolean hasBooleanLiteralOperand(AstNode astNode) {
        return astNode.is(FlexGrammar.POSTFIX_EXPR) && astNode.getFirstChild().is(FlexGrammar.PRIMARY_EXPR) && astNode.getFirstChild().getFirstChild().is(FlexKeyword.TRUE, FlexKeyword.FALSE);
    }
}

