/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1185")
public class FunctionOnlyCallsSuperCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.FUNCTION_DEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!FunctionOnlyCallsSuperCheck.isOverridingParentFunction(astNode.getPreviousAstNode())) {
            return;
        }
        AstNode singleDirectiveNode = FunctionOnlyCallsSuperCheck.getSingleStatementBlock(astNode);
        if (singleDirectiveNode != null && FunctionOnlyCallsSuperCheck.isSuperOrReturnOfSuperReference(singleDirectiveNode.getFirstChild())) {
            List<String> parameters = FunctionOnlyCallsSuperCheck.getParametersName(astNode);
            String methodName = Function.getName(astNode);
            if (FunctionOnlyCallsSuperCheck.isUselessCallToSuper(singleDirectiveNode.getFirstChild(FlexGrammar.STATEMENT), methodName, parameters) && !FunctionOnlyCallsSuperCheck.hasMetadataTag(astNode.getParent().getParent().getPreviousAstNode())) {
                this.addIssue(MessageFormat.format("Remove this method \"{0}\" to simply inherit it.", methodName), astNode);
            }
        }
    }

    private static boolean hasMetadataTag(AstNode directive) {
        return directive.getFirstChild().is(FlexGrammar.STATEMENT) && directive.getFirstChild().getFirstChild().is(FlexGrammar.METADATA_STATEMENT);
    }

    private static AstNode getSingleStatementBlock(AstNode functionDef) {
        AstNode functionBlock = functionDef.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.BLOCK);
        if (functionBlock != null && functionBlock.getFirstChild(FlexGrammar.DIRECTIVES).getNumberOfChildren() == 1) {
            return functionBlock.getFirstChild(FlexGrammar.DIRECTIVES).getFirstChild();
        }
        return null;
    }

    private static boolean isSuperReference(AstNode statement) {
        return statement.getFirstChild(FlexGrammar.EXPRESSION_STATEMENT) != null && FunctionOnlyCallsSuperCheck.isSuperExpression(statement.getFirstChild().getFirstChild().getFirstChild());
    }

    private static boolean isSuperExpression(AstNode listExpression) {
        AstNode postfixExpr = listExpression.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR);
        return postfixExpr != null && postfixExpr.getFirstChild(FlexGrammar.SUPER_EXPR) != null;
    }

    private static boolean isReturnOfSuperReference(AstNode statement) {
        return statement.getFirstChild().is(FlexGrammar.RETURN_STATEMENT) && statement.getFirstChild().getFirstChild(FlexGrammar.LIST_EXPRESSION) != null && FunctionOnlyCallsSuperCheck.isSuperExpression(statement.getFirstChild().getFirstChild(FlexGrammar.LIST_EXPRESSION));
    }

    private static boolean isSuperOrReturnOfSuperReference(AstNode directiveChild) {
        return directiveChild.is(FlexGrammar.STATEMENT) && (FunctionOnlyCallsSuperCheck.isSuperReference(directiveChild) || FunctionOnlyCallsSuperCheck.isReturnOfSuperReference(directiveChild));
    }

    private static List<String> getParametersName(AstNode functionDef) {
        ArrayList<String> parametersNames = Lists.newArrayList();
        for (AstNode identifier : Function.getParametersIdentifiers(functionDef)) {
            parametersNames.add(identifier.getTokenValue());
        }
        return parametersNames;
    }

    private static boolean isOverridingParentFunction(@Nullable AstNode attributesNode) {
        if (attributesNode != null && attributesNode.is(FlexGrammar.ATTRIBUTES)) {
            for (AstNode attribute : attributesNode.getChildren()) {
                if (!attribute.getFirstChild().is(FlexGrammar.ATTRIBUTE_EXPR) || attribute.getFirstChild().getNumberOfChildren() != 1 || !attribute.getFirstChild().getFirstChild(FlexGrammar.IDENTIFIER).getTokenValue().equals(FlexKeyword.OVERRIDE.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUselessCallToSuper(AstNode singleStatement, String methodName, List<String> parameters) {
        String expected;
        StringBuilder sb = new StringBuilder();
        for (Token token : singleStatement.getFirstChild().getTokens()) {
            sb.append(token.getValue());
        }
        String actual = sb.toString();
        return actual.equals(expected = FlexKeyword.SUPER.getValue() + "." + methodName + "(" + Joiner.on(",").join(parameters) + ");") || actual.equals(FlexKeyword.RETURN.getValue() + expected);
    }
}

