/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1439")
public class LabelPlacementCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.LABELED_STATEMENT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!LabelPlacementCheck.isIterationStatement(astNode.getFirstChild(FlexGrammar.SUB_STATEMENT))) {
            this.addIssue(MessageFormat.format("Remove this ''{0}'' label.", astNode.getFirstChild(FlexGrammar.IDENTIFIER).getTokenValue()), astNode);
        }
    }

    private static boolean isIterationStatement(AstNode subStatement) {
        AstNode astNode = subStatement.getFirstChild();
        return astNode.is(FlexGrammar.STATEMENT) && astNode.getFirstChild().is(FlexGrammar.WHILE_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.FOR_STATEMENT);
    }
}

