/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="OneStatementPerLine")
public class OneStatementPerLineCheck
extends FlexCheck {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.STATEMENT, FlexGrammar.VARIABLE_DECLARATION_STATEMENT);
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    @Override
    public void visitNode(AstNode statementNode) {
        if (!this.isExcluded(statementNode)) {
            int line = statementNode.getTokenLine();
            this.statementsPerLine.compute(line, (k, v) -> v == null ? 1 : v + 1);
        }
    }

    @Override
    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            this.addIssueAtLine(MessageFormat.format("At most one statement is allowed per line, but {0} statements were found on this line.", statementsAtLine.getValue()), statementsAtLine.getKey());
        }
    }

    public boolean isExcluded(AstNode astNode) {
        AstNode statementNode = astNode.getFirstChild();
        return statementNode.is(FlexGrammar.BLOCK) || statementNode.is(FlexGrammar.EMPTY_STATEMENT) || statementNode.is(FlexGrammar.LABELED_STATEMENT);
    }
}

