/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1151")
public class TooManyLinesInCaseCheck
extends FlexCheck {
    private static final int DEFAULT = 5;
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="5")
    int max = 5;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CASE_ELEMENT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        AstNode lastLabelNode = Iterables.getLast(astNode.getChildren(FlexGrammar.CASE_LABEL));
        int lines = Math.max(astNode.getNextAstNode().getTokenLine() - lastLabelNode.getTokenLine(), 1);
        if (lines > this.max) {
            this.addIssue(MessageFormat.format("Reduce this switch case number of lines from {0} to at most {1}, for example by extracting code into methods.", lines, this.max), lastLabelNode);
        }
    }
}

