/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1172")
public class UnusedFunctionParametersCheck
extends FlexCheck {
    private Deque<Boolean> classes = new ArrayDeque<Boolean>();
    private static final AstNodeType[] FUNCTION_NODES = new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR};
    private Scope currentScope;

    @Override
    public List<AstNodeType> subscribedTo() {
        ArrayList<AstNodeType> types = new ArrayList<AstNodeType>();
        types.add(FlexGrammar.POSTFIX_EXPR);
        types.add(FlexGrammar.PARAMETERS);
        types.add(FlexGrammar.CLASS_DEF);
        Collections.addAll(types, FUNCTION_NODES);
        return types;
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.currentScope = null;
        this.classes.clear();
    }

    @Override
    public void visitNode(AstNode astNode) {
        AstNode postfixExprChild;
        if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.classes.push(UnusedFunctionParametersCheck.implementsAnInterface(astNode));
        } else if (astNode.is(FUNCTION_NODES)) {
            this.currentScope = new Scope(this.currentScope, astNode);
        } else if (this.currentScope != null && astNode.is(FlexGrammar.PARAMETERS) && astNode.getParent().is(FlexGrammar.FUNCTION_SIGNATURE)) {
            this.declareInCurrentScope(Function.getParametersIdentifiers(this.currentScope.functionDec));
        } else if (this.currentScope != null && astNode.is(FlexGrammar.POSTFIX_EXPR) && (postfixExprChild = astNode.getFirstChild()).is(FlexGrammar.PRIMARY_EXPR) && postfixExprChild.getNextAstNode().isNot(FlexGrammar.ARGUMENTS)) {
            this.currentScope.use(UnusedFunctionParametersCheck.getPrimaryExpressionStringValue(postfixExprChild));
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(FUNCTION_NODES) && UnusedFunctionParametersCheck.isNotAbstract(astNode)) {
            if (!this.isExcluded(astNode)) {
                this.reportUnusedArgument();
            }
            this.currentScope = this.currentScope.outerScope;
        } else if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.classes.pop();
        }
    }

    private void reportUnusedArgument() {
        int nbUnusedArgs = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.currentScope.arguments.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            builder.append((String)entry.getKey() + " ");
            ++nbUnusedArgs;
        }
        if (nbUnusedArgs > 0) {
            this.addIssue(MessageFormat.format("Remove the unused function {0} \"{1}\".", nbUnusedArgs > 1 ? "parameters" : "parameter", StringUtils.join((Object[])builder.toString().trim().split(" "), ", ")), this.currentScope.functionDec);
        }
    }

    private boolean isExcluded(AstNode functionDec) {
        AstNode directives = functionDec.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES);
        return UnusedFunctionParametersCheck.isExcludedFunctionDeclaration(functionDec) || UnusedFunctionParametersCheck.isEmpty(directives) || UnusedFunctionParametersCheck.containsOnlyThrowStmt(directives) || this.isInClassImplementingInterface();
    }

    private static Boolean implementsAnInterface(AstNode classDef) {
        AstNode inheritenceNode = classDef.getFirstChild(FlexGrammar.INHERITENCE);
        return inheritenceNode != null && inheritenceNode.getFirstChild().is(FlexKeyword.IMPLEMENTS);
    }

    private boolean isInClassImplementingInterface() {
        return !this.classes.isEmpty() && this.classes.peek() != false;
    }

    private static boolean containsOnlyThrowStmt(AstNode directives) {
        List<AstNode> directiveList = directives.getChildren();
        if (directiveList.size() == 1) {
            AstNode directiveKind = directiveList.get(0).getFirstChild().getFirstChild();
            return directiveKind.is(FlexGrammar.THROW_STATEMENT);
        }
        return false;
    }

    private static boolean isEmpty(AstNode directives) {
        return directives.getNumberOfChildren() == 0;
    }

    private void declareInCurrentScope(List<AstNode> identifiers) {
        for (AstNode identifier : identifiers) {
            this.currentScope.declare(identifier);
        }
    }

    private static boolean isExcludedFunctionDeclaration(AstNode functionDec) {
        return functionDec.is(FlexGrammar.FUNCTION_DEF) && (Function.isOverriding(functionDec) || UnusedFunctionParametersCheck.isEventHandler(functionDec));
    }

    private static boolean isEventHandler(AstNode functionDec) {
        AstNode firstParameter;
        AstNode parameters;
        String functionName = functionDec.getFirstChild(FlexGrammar.FUNCTION_NAME).getTokenValue();
        if ((functionName.toLowerCase(Locale.ENGLISH).contains("handle") || UnusedFunctionParametersCheck.startsWithOnPreposition(functionName)) && (parameters = functionDec.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.FUNCTION_SIGNATURE).getFirstChild(FlexGrammar.PARAMETERS)) != null && (firstParameter = parameters.getFirstChild(FlexGrammar.PARAMETER)) != null && firstParameter.getFirstChild(FlexGrammar.TYPED_IDENTIFIER) != null) {
            AstNode firstParameterType = firstParameter.getFirstChild(FlexGrammar.TYPED_IDENTIFIER).getFirstChild(FlexGrammar.TYPE_EXPR);
            return firstParameterType != null && firstParameterType.getLastToken().getValue().endsWith("Event");
        }
        return false;
    }

    private static boolean startsWithOnPreposition(String name) {
        return name.startsWith("on") && (name.length() == 2 || name.substring(2, 3).matches("[A-Z]"));
    }

    private static boolean isNotAbstract(AstNode functionDef) {
        return functionDef.getFirstChild(FlexGrammar.FUNCTION_COMMON).getLastChild().is(FlexGrammar.BLOCK);
    }

    private static String getPrimaryExpressionStringValue(AstNode postfixExpr) {
        StringBuilder builder = new StringBuilder();
        for (Token t : postfixExpr.getTokens()) {
            builder.append(t.getValue());
        }
        return builder.toString();
    }

    private static class Scope {
        private final Scope outerScope;
        private final AstNode functionDec;
        private final Map<String, Integer> arguments;

        public Scope(Scope outerScope, AstNode functionDec) {
            this.outerScope = outerScope;
            this.functionDec = functionDec;
            this.arguments = Maps.newLinkedHashMap();
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState(astNode.is(FlexGrammar.IDENTIFIER));
            String identifier = astNode.getTokenValue();
            this.arguments.put(identifier, 0);
        }

        private void use(String value) {
            Scope scope = this;
            while (scope != null) {
                Integer usage = scope.arguments.get(value);
                if (usage != null) {
                    Integer n = usage;
                    Integer n2 = usage = Integer.valueOf(usage + 1);
                    scope.arguments.put(value, usage);
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }
}

