/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.flex.FlexGrammar;

public final class MetadataTag {
    private MetadataTag() {
    }

    public static boolean isTag(AstNode metadata, String tagName) {
        Preconditions.checkArgument(metadata.is(FlexGrammar.METADATA_STATEMENT));
        if (MetadataTag.isNotEmpty(metadata)) {
            AstNode postfixExpr = metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR);
            return postfixExpr != null && tagName.equals(postfixExpr.getTokenValue());
        }
        return false;
    }

    public static List<String> getSinglePropertyAsList(AstNode metadata) {
        AstNode properties;
        Preconditions.checkArgument(metadata.is(FlexGrammar.METADATA_STATEMENT));
        ArrayList<String> propertyList = Lists.newArrayList();
        if (MetadataTag.isNotEmpty(metadata) && MetadataTag.hasProperty(metadata) && (properties = metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR).getFirstChild(FlexGrammar.ARGUMENTS).getFirstChild(FlexGrammar.LIST_EXPRESSION)).getNumberOfChildren() == 1) {
            String singleProperty = properties.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getTokenValue();
            for (String property : singleProperty.substring(1, singleProperty.length() - 1).split(",")) {
                propertyList.add(property.trim());
            }
        }
        return propertyList;
    }

    public static Map<String, String> getTagPropertiesMap(AstNode metadata) {
        Preconditions.checkArgument(metadata.is(FlexGrammar.METADATA_STATEMENT));
        if (MetadataTag.isNotEmpty(metadata) && MetadataTag.hasProperty(metadata)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            AstNode listExpr = metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR).getFirstChild(FlexGrammar.ARGUMENTS).getFirstChild(FlexGrammar.LIST_EXPRESSION);
            for (AstNode assignmentExpr : listExpr.getChildren(FlexGrammar.ASSIGNMENT_EXPR)) {
                if (assignmentExpr.getFirstChild(FlexGrammar.ASSIGNMENT_OPERATOR) == null) continue;
                properties.put(assignmentExpr.getFirstChild(FlexGrammar.ASSIGNMENT_OPERATOR).getPreviousSibling().getTokenValue(), assignmentExpr.getFirstChild(FlexGrammar.ASSIGNMENT_OPERATOR).getNextSibling().getTokenValue());
            }
            return properties;
        }
        return null;
    }

    public static boolean isNotEmpty(AstNode metadata) {
        return metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR) != null && metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR) != null;
    }

    public static boolean hasProperty(AstNode metadata) {
        Preconditions.checkArgument(metadata.is(FlexGrammar.METADATA_STATEMENT));
        AstNode arguments = metadata.getFirstChild(FlexGrammar.ASSIGNMENT_EXPR).getFirstChild(FlexGrammar.POSTFIX_EXPR).getFirstChild(FlexGrammar.ARGUMENTS);
        return arguments != null && arguments.getFirstChild(FlexGrammar.LIST_EXPRESSION) != null;
    }

    public static boolean isMetadataTag(AstNode directive) {
        return directive.getFirstChild().is(FlexGrammar.STATEMENT) && directive.getFirstChild().getFirstChild().is(FlexGrammar.METADATA_STATEMENT);
    }
}

