/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.flex;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Lexer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.flex.FlexVisitor;
import org.sonar.flex.api.FlexKeyword;
import org.sonar.flex.api.FlexPunctuator;
import org.sonar.flex.api.FlexTokenType;
import org.sonar.plugins.flex.TokenLocation;

public class FlexTokensVisitor
extends FlexVisitor {
    private static final String NORMALIZED_CHARACTER_LITERAL = "$CHARS";
    private static final String NORMALIZED_NUMERIC_LITERAL = "$NUMBER";
    private static final Set<FlexKeyword> KEYWORDS = Sets.immutableEnumSet(Arrays.asList(FlexKeyword.values()));
    private final SensorContext context;
    private final Lexer lexer;
    private final InputFile inputFile;

    public FlexTokensVisitor(SensorContext context, Lexer lexer, InputFile inputFile) {
        this.context = context;
        this.lexer = lexer;
        this.inputFile = inputFile;
    }

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        NewHighlighting highlighting = this.context.newHighlighting();
        highlighting.onFile(this.inputFile);
        NewCpdTokens cpdTokens = this.context.newCpdTokens();
        cpdTokens.onFile(this.inputFile);
        Iterator<Token> iterator = this.lexer.lex(this.getContext().fileContent()).iterator();
        boolean importDirective = false;
        while (iterator.hasNext()) {
            Token token = iterator.next();
            TokenType tokenType = token.getType();
            if (tokenType.equals(FlexKeyword.IMPORT)) {
                importDirective = true;
            } else if (importDirective) {
                if (tokenType.equals(FlexPunctuator.SEMI)) {
                    importDirective = false;
                }
            } else if (!tokenType.equals(GenericTokenType.EOF)) {
                TokenLocation tokenLocation = new TokenLocation(token);
                cpdTokens.addToken(tokenLocation.startLine(), tokenLocation.startCharacter(), tokenLocation.endLine(), tokenLocation.endCharacter(), FlexTokensVisitor.getTokenImage(token));
            }
            if (tokenType.equals(FlexTokenType.NUMERIC_LITERAL)) {
                FlexTokensVisitor.highlight(highlighting, token, TypeOfText.CONSTANT);
            } else if (tokenType.equals(GenericTokenType.LITERAL)) {
                FlexTokensVisitor.highlight(highlighting, token, TypeOfText.STRING);
            } else if (KEYWORDS.contains(tokenType)) {
                FlexTokensVisitor.highlight(highlighting, token, TypeOfText.KEYWORD);
            }
            for (Trivia trivia : token.getTrivia()) {
                FlexTokensVisitor.highlight(highlighting, trivia.getToken(), TypeOfText.COMMENT);
            }
        }
        highlighting.save();
        cpdTokens.save();
    }

    private static String getTokenImage(Token token) {
        if (token.getType().equals(GenericTokenType.LITERAL)) {
            return NORMALIZED_CHARACTER_LITERAL;
        }
        if (token.getType().equals(FlexTokenType.NUMERIC_LITERAL)) {
            return NORMALIZED_NUMERIC_LITERAL;
        }
        return token.getValue();
    }

    private static void highlight(NewHighlighting highlighting, Token token, TypeOfText typeOfText) {
        TokenLocation tokenLocation = new TokenLocation(token);
        highlighting.highlight(tokenLocation.startLine(), tokenLocation.startCharacter(), tokenLocation.endLine(), tokenLocation.endCharacter(), typeOfText);
    }
}

