/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public final class Index {
    public static final Index ALL_INDICES = Index.simple("_all");
    private final String name;
    private final boolean relations;

    private Index(String name, boolean acceptsRelations) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Index name can't be null nor empty");
        Preconditions.checkArgument(("_all".equals(name) || StringUtils.isAllLowerCase((String)name) ? 1 : 0) != 0, (String)"Index name must be lower-case letters or '_all': %s", (Object[])new Object[]{name});
        this.name = name;
        this.relations = acceptsRelations;
    }

    public static Index simple(String name) {
        return new Index(name, false);
    }

    public static Index withRelations(String name) {
        return new Index(name, true);
    }

    public String getName() {
        return this.name;
    }

    public boolean acceptsRelations() {
        return this.relations;
    }

    public String getJoinField() {
        Preconditions.checkState((boolean)this.relations, (Object)"Only index accepting relations has a join field");
        return "join_" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return this.relations == index.relations && this.name.equals(index.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.relations);
    }

    public String toString() {
        return "[" + this.name + (this.relations ? "|*" : "|") + ']';
    }
}

