/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonar.api.server.ServerSide;
import org.sonar.server.es.Index;
import org.sonar.server.es.newindex.NewAuthorizedIndex;
import org.sonar.server.es.newindex.NewIndex;
import org.sonar.server.es.newindex.NewRegularIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;

@ServerSide
public interface IndexDefinition {
    public void define(IndexDefinitionContext var1);

    public static class IndexDefinitionContext {
        private final Map<String, NewIndex> byKey = Maps.newHashMap();

        public NewRegularIndex create(Index index, SettingsConfiguration settingsConfiguration) {
            String indexName = index.getName();
            Preconditions.checkArgument((!this.byKey.containsKey(indexName) ? 1 : 0) != 0, (Object)String.format("Index already exists: %s", indexName));
            NewRegularIndex newIndex = new NewRegularIndex(index, settingsConfiguration);
            this.byKey.put(indexName, newIndex);
            return newIndex;
        }

        public NewAuthorizedIndex createWithAuthorization(Index index, SettingsConfiguration settingsConfiguration) {
            Preconditions.checkArgument((boolean)index.acceptsRelations(), (Object)"Index with authorization must accept relations");
            String indexName = index.getName();
            Preconditions.checkArgument((!this.byKey.containsKey(indexName) ? 1 : 0) != 0, (Object)String.format("Index already exists: %s", indexName));
            NewAuthorizedIndex newIndex = new NewAuthorizedIndex(index, settingsConfiguration);
            this.byKey.put(indexName, newIndex);
            return newIndex;
        }

        public Map<String, NewIndex> getIndices() {
            return this.byKey;
        }
    }
}

